@extends('master')
@section('content')

<div class="page-content-wrapper">
    <!-- BEGIN CONTENT BODY -->
    <div class="page-content">
        <!-- BEGIN PAGE BAR -->
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <a href="">Reportes</a>
                    <i class="fa fa-circle"></i>
                </li>
                <li>
                <span></span>
                </li>
            </ul>
            <div class="page-toolbar">
            <div class="pull-right btn-sm">
                <i class="icon-calendar"></i>&nbsp;
                    <script>
                        var meses = new Array ("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
                        var diasSemana = new Array("Domingo","Lunes","Martes","Miércoles","Jueves","Viernes","Sábado");
                        var f=new Date();
                        document.write(diasSemana[f.getDay()] + ", " + f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear());
                    </script>
            </div>
        </div>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h3 class="page-title"></h3>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    <!-- BEGIN DASHBOARD STATS 1-->
    <div class="clearfix"></div>

    <div class="row">
        <div class="col-md-12">
            @if (Session::has('message'))
                <div class="alert alert-danger">
                    <p>
                        {{ Session::get('message') }}
                    </p>
                </div>
            @endif
        </div>
    </div>


    <div class="row">    
        <div class="col-md-10">
            <div class="col-md-12" style="background-color:#fff; padding:10px 20px; margin-bottom:10px;">
                <span class="caption-subject bold uppercase" style="float: left; display: inline-block; padding: 12px 0;">Reporte</span>
            </div>
                    
            <div class="col-md-12" style="background-color:#fff; padding:30px; margin-bottom:20px;">
                <div class="portlet">

                   
                    <div class="portlet box red">
                        <div class="portlet-title">
                            <div class="caption">
                                Egresos<i class="fa fa-cogs"></i> 
                            </div>
                            <div class="tools">
                                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                                <a href="javascript:;" class="reload" data-original-title="" title=""> </a>
                            </div>
                        </div>
                        <div class="portlet-body">
                          
                            
                            <input type="hidden" value="{{$incomepercentage}}" id="uno"/>
                            <input type="hidden" value="{{$months}}" id="month_select" />
                            <input type="hidden" value="{{$incomenumeral}}" id="income" />
                            <input type="hidden" value="{{$expense}}" id="expense" />

                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div>
                                        <canvas id="myPieChart" width="100px" height="100px" style="width:100px;height:100px;"></canvas>
                                    </div>
                                    <div>
                                        <p>${{$incomenumeral}} MXN recibido</p>
                                        <p>Esperado del mes ${{$incometotal}} MXN</p>
                                        <p>{{$resident}} usuarios aportaron el mes seleccionado</p>
                                        <p>{{$residentpercent}} % de usuarios que aportaron el mes seleccionado</p>
                                        <p>{{$incomepercentage}}% recibido</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div>
                                        <canvas id="myBarChart" width="100px" height="100px" style="width:100px;height:100px;"></canvas>
                                    </div>
                                    <div>
                                        <p>${{$expense}} MXN de egresos</p>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <canvas id="myBarChartExpenses" width="100px" height="100px" style="width:100px;height:100px;"></canvas>
                                  
                                    @foreach($expensecategory as $key => $expenses)
                                        <input type="hidden" id="{{$expensecategory[$key]['id']}}" name="{{$expensecategory[$key]['category_name']}}" value="{{$expensecategory[$key]['amount']}}" />
                                    @endforeach
                                </div>
                            </div>
                            <div class="row">
                                {!! Form::open(['method' => 'GET', 'action' => 'ReportAdminController@index', 'id' => '']) !!}
                                <div class="col-md-6">
                                    <div>
                                        <label>Selecciona mes</label>
                                        <select class="form-control" name="month">
                                            @foreach($month as $mons)
                                                @if($mons->id == $months)
                                                    <option value="{{$mons->id}}" selected>{{$mons->month_year_text}}</option>
                                                @else
                                                    <option value="{{$mons->id}}">{{$mons->month_year_text}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </div>
                                    <button type="submit" class="btn btn-success">Buscar</button>
                                </div>
                                    
                                {!! Form::close() !!}
                            </div>

                        </div>
                    </div>
                    </div>

                    
   
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function MM_openBrWindow(theURL,winName,features) { //v2.0
      window.open(theURL,winName,features);
    }

    //var expensecategory = $("#expensecategory").val();

    var unoamount    = $("#1").val();
    var unoname      = $("#1").attr("name");
    var dosamount    = $("#2").val();
    var dosname      = $("#2").attr("name");
    var tresamount   = $("#3").val();
    var tresname     = $("#3").attr("name");
    var cuatroamount = $("#4").val();
    var cuatroname   = $("#4").attr("name");
    var cincoamount  = $("#5").val();
    var cinconame    = $("#5").attr("name");
    var seisamount   = $("#6").val();
    var seisname     = $("#6").attr("name");
    var sieteamount  = $("#7").val();
    var sietename    = $("#7").attr("name");
    var ochoamount   = $("#8").val();
    var ochoname     = $("#8").attr("name");
    var nueveamount  = $("#9").val();
    var nuevename    = $("#9").attr("name");


    var data = {
        labels: [unoname,dosname,tresname,cuatroname,cinconame,seisname,sietename,ochoname,nuevename],
        datasets: [
            {
                label: "Egresos por categoría",
                backgroundColor: [
                    'rgba(255, 99, 132, 0.2)',
                    'rgba(54, 162, 235, 0.2)'
                    
                ],
                borderColor: [
                    'rgba(255,99,132,1)',
                    'rgba(54, 162, 235, 1)'
                   
                ],
                borderWidth: 1,
                data: [unoamount,dosamount,tresamount,cuatroamount,cincoamount,seisamount,sieteamount,ochoamount,nueveamount,0],
            }
        ]
    };

    var ctx = document.getElementById("myBarChartExpenses");
    var myBarChart = new Chart(ctx, {
        type: 'bar',
        data: data,
        options: {
            //responsive:false
        }
    });





    var uno = $("#uno").val();
    var dos = 100-uno;
    var por = "%";

    var data = {
        labels: [
            "% Recibido",
            "% Por recibir",
        ],
        datasets: [
            {
                data: [uno,dos],
                backgroundColor: [
                    "#FF6384",
                    "#36A2EB",
                   
                ],
                hoverBackgroundColor: [
                    "#FF6384",
                    "#36A2EB",
                   
                ]
            }]
    };
    var ctx = document.getElementById("myPieChart");
    var myPieChart = new Chart(ctx,{
        type: 'pie',
        data: data,
        options: {
            animation:{
                animateScale:true
            },
            //responsive:false
        }
        
    });



    var month = $("#month_select").val();
    var income = $("#income").val();
    var expense = $("#expense").val();


    var data2 = {
        labels: ["Ingresos", "Egresos"],
        datasets: [
            {
                label: "Ingresos vs Egresos",
                backgroundColor: [
                    'rgba(255, 99, 132, 0.2)',
                    'rgba(54, 162, 235, 0.2)'
                    
                ],
                borderColor: [
                    'rgba(255,99,132,1)',
                    'rgba(54, 162, 235, 1)'
                   
                ],
                borderWidth: 1,
                data: [income,expense,0],
            }
        ]
    };

    var ctx2 = document.getElementById("myBarChart");
    var myBarChart = new Chart(ctx2, {
        type: 'bar',
        data: data2,
        options: {
            //responsive:false
        }
    });

</script>


@endsection