@extends('master')
@section('content')


<div class="page-content-wrapper">
    <!-- BEGIN CONTENT BODY -->
    <div class="page-content">
    	<!-- BEGIN PAGE BAR -->
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <a href=""></a>
                    <i class="fa fa-circle"></i>
                </li>
             	<li>
                     <span>Eventos</span>
                </li>
            </ul>
            <div class="page-toolbar">
                <div class="pull-right btn-sm">
                    <i class="icon-calendar"></i>&nbsp;
                        <script>
                            var meses = new Array ("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
                            var diasSemana = new Array("Domingo","Lunes","Martes","Miércoles","Jueves","Viernes","Sábado");
                            var f=new Date();
                            document.write(diasSemana[f.getDay()] + ", " + f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear());
                        </script>
                </div>
            </div>
        </div>
        <!-- END PAGE BAR -->
        <!-- BEGIN PAGE TITLE-->
        <h3 class="page-title"><a href="{{ url('/reservation/resident') }}"><i class="icon-arrow-left"></i></a>Eventos</h3>
        <!-- END PAGE TITLE-->
        <!-- END PAGE HEADER-->
        <!-- BEGIN DASHBOARD STATS 1-->
        <div class="clearfix"></div>

        <div class="row">
            <div class="col-md-12">
                @if (Session::has('message'))
                   <div class="alert alert-danger">
                        <p>
                            {{ Session::get('message') }}
                        </p>
                     </div>
                @endif
            </div>
         </div>

        <div class="col-md-10">
            <div class="col-md-12" style="background-color:#fff; padding:10px 20px; margin-bottom:10px;">
                <span class="caption-subject" style="float: left; display: inline-block; padding: 12px 0;">Agregar Empleados y Trabajadores</span>
                <div class="actions">
                    <div class="btn-group">
                            
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                 @endforeach
                            </ul>
                        </div>
                    @endif
                </div>
            </div>

            <div class="col-md-12" style="background-color:#fff; padding:30px; margin-bottom:20px;">
                    <div class="portlet">
                        <div class="portlet-title">
                            <div class="caption">
                                <span class=""> </span>
                            </div>
                        </div>
                        {!! Form::open(['method' => 'POST', 'action' => 'EmployeController@store', 'id' => 'formemploye']) !!}
                            <div class="col-lg-8 col-md-8 login-container bs-reset">
                                <div class="login-content">
                                        
                                        <div class="row">
                                            <div class="col-md-6">
                                                <label for="form_control_1">Tipo</label>
                                                <select id="employe_type" class="form-control" name="employes_type" autocomplete="off" required>
                                                    <option value="">-Selecciona-</option>
                                                    @foreach($type as $types)
                                                        <option value="{{$types->name}}">{{$types->name_type}}</option>
                                                    @endforeach
                                                </select>
                                                @if ($errors->has('employe_type'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('employe_type') }}</strong>
                                                </span>
                                                @endif
                                            </div>
                                        </div>
                               
                                        <div id="recurrente" style="display:none;">
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <label>Nombre</label>
                                                    <input type="text" id="name" name="name" value="{{ old('name')}}" class="form-control"  required>
                                                </div>
                                                <div class="col-md-8">
                                                    <label>Días que puede acceder </label>
                                                    <p>Lunes</p>
                                                    <input type="checkbox" id="monday" name="monday" class="form-control">
                                                    <p>Martes</p>
                                                    <input type="checkbox" id="tuesday" name="tuesday" class="form-control">
                                                    <p>Miércoles</p>
                                                    <input type="checkbox" id="wendsday" name="wendsday" class="form-control">
                                                    <p>Jueves</p>
                                                    <input type="checkbox" id="thursday" name="thursday" class="form-control">
                                                    <p>Viernes</p>
                                                    <input type="checkbox" id="friday" name="friday" class="form-control">
                                                    <p>Sábado</p>
                                                    <input type="checkbox" id="saturday" name="saturday" class="form-control">
                                                    <p>Domingo</p>
                                                    <input type="checkbox" id="sunday" name="sunday" class="form-control">
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <label>Horario</label>
                                                    <div>
                                                        <div class="bootstrap-timepicker dropdown">
                                                            <input class="timepicker-example form-control" id="time_start" name="time_start" type="text">
                                                        </div>

                                                        <div class="bootstrap-timepicker dropdown">
                                                            <input class="timepicker-example form-control" id="time_end" name="time_end" type="text">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-md-4">
                                                    <label>Fecha fin</label>
                                                    <div class="input-prepend input-group">
                                                        <span class="add-on input-group-addon">
                                                           <i class="glyph-icon icon-calendar"></i>
                                                        </span>
                                                        <input type="text" class="bootstrap-datepicker form-control" id="date_end" name="date_end" value="{{ old('date')}}" data-date-format="mm/dd/yy">
                                                    </div>
                                                </div>

                                                <div class="col-md-4">
                                                    <label>Subir foto</label>
                                                    <input type="file" id="photo" name="photo" value="{{ old('photo')}}" class="form-control">
                                                </div>

                                            </div>
                                        </div>

                                        <div id="eventual" style="display:none;">
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <label>Nombre</label>
                                                    <input type="text" id="description" name="description" value="{{ old('description')}}" class="form-control">
                                                </div>
                                                <div class="col-md-4">
                                                    <label>Fecha</label>
                                                    <div class="input-prepend input-group">
                                                        <span class="add-on input-group-addon">
                                                           <i class="glyph-icon icon-calendar"></i>
                                                        </span>
                                                        <input type="text" class="bootstrap-datepicker form-control" id="date_start" name="date_start" value="{{ old('date')}}" data-date-format="mm/dd/yy">
                                                    </div>
                                                </div>

                                                <div class="col-md-4">
                                                    <label>Subir foto</label>
                                                    <input type="file" id="photo" name="photo" value="{{ old('photo')}}" class="form-control">
                                                </div>

                                            </div>
                                        </div>

                                        
                                        <div class="row">
                                            <div class="col-md-12">
                                                <button type="submit" class="btn btn-sm green dropdown-toggle">Guardar</button>
                                            </div>
                                        </div>
                                </div>
                            </div>
                            
                        {!! Form::close() !!}

                           
                    </div>
            </div>
      
        </div>

	</div>

</div>

<script type="text/javascript">

</script>
{!! Html::script('js/employes.js') !!}


@endsection