@extends('master')
@section('content')

<style>
.form-control[readonly]
{
    cursor:pointer!important;
}
.manita
{
    cursor:pointer;
}
</style>

{!! Html::style('vendor/fullcalendar/fullcalendar.min.css') !!}
<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Reservar área</h2>
            <p>Haz tus reservaciones de áreas sociales con tiempo</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')
</div><!--BREADCRUMB END-->


@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif
@if ($errors->has('file'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('file') }}</li>         
        </ul>
    </div>                                             
@endif
@if ($errors->has('error2'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error2') }}</li>         
        </ul>
    </div>                                             
@endif
@include('sessionmessage')


@if(Auth::user()->reservation_permission == 0)
<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            No tienes permiso para agregar eventos.
        </h3>
    </div>
</div>
@else
<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Eventos
            <div class="header-buttons" style="padding-top:5px;">
                @if( $errors->has('title') || $errors->has('social_area') || $errors->has('date') || $errors->has('time_start') || $errors->has('time_end'))
                    <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                @else
                    @if($abierto == 1)
                        <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                    @else
                        <a href="#" id="btnagregarevento" class="btn btn-md btn-danger collapsed" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-plus"></i></a>
                    @endif
                    
                @endif
            </div>
        </h3>
        {!! Form::open(['method' => 'POST', 'action' => 'ReservationResController@store', 'enctype' => 'multipart/form-data' , 'id' => 'formresrvationres']) !!}
        <div class="example-box-wrapper">
            <div class="row">
                
                <div class="col-md-12">
                    @if( $errors->has('title') || $errors->has('social_area') || $errors->has('date') || $errors->has('time_start') || $errors->has('time_end'))
                        <div id="demo-2" class="collapse in" aria-expanded="true">
                    @else 
                        @if($abierto == 1)  
                            <div id="demo-2" class="collapse in" aria-expanded="true">
                        @else
                            <div id="demo-2" class="collapse" aria-expanded="true">
                        @endif
                    @endif
                        <div class="form-horizontal pad15L pad15R bordered-row">

                            <div class="form-group remove-border">

                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">
                                            Evento:*</label>
                                        <div class="col-sm-8 form-group{{ $errors->has('title') ? ' has-error' : '' }}">
                                            <input type="text" class="form-control" id="title" name="title" value="{{ old('title')}}" placeholder="Nombre del evento..." required>
                                            @if ($errors->has('title'))
                                              <span class="help-block">
                                                <strong>{{ $errors->first('title') }}</strong>
                                              </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">
                                            Área social:*</label>
                                        <div class="col-sm-8 form-group{{ $errors->has('social_area') ? ' has-error' : '' }}">
                                            <select class="form-control" id="socialarea" name="social_area" required>
                                                <option value="">-Selecciona-</option>
                                                    <!--#Ocultar Area Social-->
                                                    @foreach($social_area as $social_areas)
                                                        @if($social_areas->id == old('social_area'))
                                                            @if($social_areas->ocult_area == 0)
                                                                <option value="{{$social_areas->id}}" selected>{{$social_areas->name_social_area}}</option>
                                                            @endif
                                                        @else
                                                            @if($social_areas->ocult_area == 0)
                                                                <option value="{{$social_areas->id}}">{{$social_areas->name_social_area}}</option>
                                                            @endif
                                                        @endif
                                                    @endforeach
                                            </select>
                                            @if ($errors->has('social_area'))
                                              <span class="help-block">
                                                <strong>{{ $errors->first('social_area') }}</strong>
                                              </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4" style="display:none;" id="reglamento">
                                    <div class="row">
                                        <label class="col-sm-5 control-label">
                                            Reglamento:</label>
                                        <div class="col-sm-7" >
                                            <a href="" id="reglamentofile" target="blank" class="btn btn-xs btn-info"><i class="glyph-icon icon-eye"></i></a>
                                        </div>
                                    </div>
                                </div>
                                        
        

                            </div>

                            <div class="form-group">

                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">
                                            Fecha:*</label>
                                        <div class="col-sm-8 form-group{{ $errors->has('date') ? ' has-error' : '' }}">
                                            <div class="input-prepend input-group">
                                                <span class="add-on input-group-addon">
                                                    <i class="glyph-icon icon-calendar"></i>
                                                </span>
                                                <input type="text" class="bootstrap-datepicker form-control manita" id="date" name="date" value="{{old('date')}}" title="aaaa-mm-dd" required>
                                            </div>
                                            @if ($errors->has('date'))
                                              <span class="help-block">
                                                <strong>{{ $errors->first('date') }}</strong>
                                              </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="row">
                                        <label for="" class="col-sm-4 control-label">Hora inicial:*</label>
                                            <div class="col-sm-8 form-group{{ $errors->has('time_start') ? ' has-error' : '' }}">
                                                <div class="bootstrap-timepicker dropdown">
                                                    <input class="timepicker-example form-control" id="time_start" name="time_start" value="{{old('time_start')}}" type="text" required>
                                                </div>
                                                @if ($errors->has('time_start'))
                                                  <span class="help-block">
                                                    <strong>{{ $errors->first('time_start') }}</strong>
                                                  </span>
                                                @endif
                                            </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="row">
                                        <label for="" class="col-sm-4 control-label">Hora final:*</label>
                                        <div class="col-sm-8 form-group{{ $errors->has('time_end') ? ' has-error' : '' }}">
                                            <div class="bootstrap-timepicker dropdown">
                                                <input class="timepicker-example form-control" id="time_end" name="time_end"  value="{{old('time_end')}}" type="text" required>
                                            </div>
                                            @if ($errors->has('time_end'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('time_end') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">
                                            <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Personas que estaran en el evento.">?</span>Cantidad de asistentes:*</label>
                                        <div class="col-sm-8 form-group{{ $errors->has('cant_asist') ? ' has-error' : '' }}">
                                            @if(old('cant_casas'))
                                                <input type="input" class="form-control" id="cant_asist" name="cant_asist" value="{{old('cant_asist')}}" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="máximo tres digitos" maxlength="3" required>
                                            @else
                                                <input type="input" class="form-control" id="cant_asist" name="cant_asist" value="1" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="máximo tres digitos" maxlength="3" placeholder="Solo numeros enteros">
                                            @endif
                                            @if ($errors->has('days_reserve_stay'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('days_reserve_stay') }}</strong>
                                                </span>
                                            @endif
                                            
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="form-group" id="gruopcost" style="display:none;">

                                <div class="col-md-4">
                                    <div class="row">
                                        
                                        <label class="col-sm-4 control-label">
                                            <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="El costo de el evento se sumara a su deuda, y cuando el administrador acepte la reservación se descontará.">?</span> Costo:</label>
                                            <div class="col-sm-8">
                                                <input type="text" class="form-control" id="cost" name="cost" readonly="readonly">
                                            </div>
                                        
                                    </div>
                                </div>

                                <div class="col-md-8">
                                    <div class="row">
                                        <div class="alert alert-warning">
                                            <p>Recuerda enviar tu comprobante por medio de la reservación de tu evento.</p>
                                        </div>
                                    </div>
                                </div>

                               

                            </div>
                                    
                        </div>


                     
                                                            
                        <div id="demo-3" class="collapse" aria-expanded="true">
                            
                            <div class="form-horizontal pad15L pad15R bordered-row">
                                
                                <div class="form-group mrg20B">

                                    <div class="col-md-8">
                                        <div class="row">
                                            <label class="col-sm-2 control-label">
                                                Invitado externo:</label>
                                            <div class="col-sm-10" >
                                                
             
                                                <div class="input-group form-guess">
                                                    <span class="input-group-addon addon-inside btn-primary" id="btnaddguest">
                                                        <i class="glyph-icon icon-plus"></i>
                                                    </span>
                                                    <input type="text" class="form-control" id="inputguest" name="guest[]" placeholder="Nombre del invitado externo" >
                                                 </div>
                                                 <div id="guests">
                                                </div>
                                                    
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>    
                        </div>

                        <div class="row" >
                                    <div class="col-md-12">
                                        <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                    </div>
                                </div>
                        
                        <div class="button-pane mrg20T">
                             <a href="#" id="btnagregarinvitado" class="btn btn-md btn-info" data-toggle="collapse" data-target="#demo-3" aria-expanded="true">Añadir invitados externos</a> 
                            <button type="button" class="btn btn-success" id="acept_reservation">Agregar evento</button>
                            <div style="display:none;">
                                <button type="submit" id="aceptarreservas"></button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
        {!! Form::close() !!}
    </div>
</div>
@endif

            
<div class="row">
    <div class="col-md-12">
                
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    Calendario de eventos
                </h3>
                <div class="example-box-wrapper row">
                    <div id="calendar" class="col-md-10 center-margin"></div>
                </div>

                        <!-- campos-->
                <input type="hidden" id="month" name="" value="{{$month}}"/>
                <input type="hidden" id="dia" name="" value="{{$dia}}"/>
                <input type="hidden" id="dateLimit" name="" value="{{$dateLimit}}"/>
                <input type="hidden" id="user" name="" value="{{Auth::user()->street_id}}">
                <input type="hidden" id="monday" name="" value="" />
                <input type="hidden" id="tuesday" name="" value="" />
                <input type="hidden" id="wendsday" name="" value="" />
                <input type="hidden" id="thursday" name="" value="" />
                <input type="hidden" id="friday" name="" value="" />
                <input type="hidden" id="saturday" name="" value="" />
                <input type="hidden" id="sunday" name="" value="" />

                <input type="hidden" id="day_select" value="" />
                        <!--<input type="hidden" id="reservation_active" value="{{$reservation_active}}" />-->
                <input type="hidden" id="reservation_active" value="{{Auth::user()->reservation_permission}}" />
                        <!-- campos -->
            </div>
        </div>
                
    </div>
</div>



<!-- MODAL DETALLES DEL EVENTO -->

<div id="modal-event" class="modal fade ag-img" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <form id="formupdateevent"  enctype="multipart/form-data" method="POST">
        <input type="hidden" name="_method" value="PUT">
        {{ csrf_field() }}
        <meta name="csrf-token" content="{{ csrf_token() }}">   
        <input type="hidden" name="resd" value="1"/>
    
        <div class="modal-content">

            <div class="modal-header">

                <div id="modalheader">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true" id="closetachitamodal">&times;</button>
                    <h4 class="modal-title">Detalles del evento</h4>
                </div>

                <div id="modalheadereliminar" style="display:none;">
                    <button type="button" id="btncerrareliminar" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
                    <h4 class="modal-title" id="mySmallModalLabel"><span>Eliminar reservación</span></h4>
                </div>

            </div>

            <div class="modal-body">

                <div id="bodymodal">
                    <!-- MENSAJE QUE APAPRECE SI EL ADMINISTRADOR NO HA ACEPTADO LA RESERVACION -->
                    <div id="message_status" class="row">
                    </div> 
                    <!-- TERMINA MENSAJE QUE APAPRECE SI EL ADMINISTRADOR NO HA ACEPTADO LA RESERVACION --> 
                     
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-horizontal pad15L pad15R bordered-row">
                                   
                                    <div class="form-group remove-border">
                                        
                                        <div class="col-md-6">
                                            
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Evento:</label>
                                                <div class="col-sm-8">
                                                    <input type="text" class="form-control" id="_title" name="_title" placeholder="Nombre del evento..." readonly="readonly">
                                                </div>
                                            </div>
                                                    
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Área social:</label>
                                                <div class="col-sm-8">
                                                    <input type="text" class="form-control" id="_social_area" name="_social_area" placeholder="Nombre del evento..." readonly="readonly">
                                                </div>
                                            </div>
                                                
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Fecha:</label>
                                                <div class="col-sm-8">
                                                    <input type="text" class="form-control" id="_date" name="_date" placeholder="Nombre del evento..." readonly="readonly">
                                                </div>
                                            </div>
                                                    
                                            <div class="row">
                                                <label for="" class="col-sm-4 control-label">Hora inicial:</label>
                                                    <div class="col-sm-8">
                                                        <input type="text" class="form-control" id="_time_start" name="_time_start"  placeholder="Nombre del evento..." readonly="readonly">
                                                    </div>
                                            </div>
                                                    
                                            <div class="row">
                                                <label for="" class="col-sm-4 control-label">Hora final:</label>
                                                    <div class="col-sm-8">
                                                        <input type="text" class="form-control" id="_time_end" name="_time_end"   placeholder="Nombre del evento..." readonly="readonly">
                                                    </div>
                                            </div>

                                             <div class="row">
                                                <label for="" class="col-sm-4 control-label">Status:</label>
                                                    <div class="col-sm-8">
                                                        <input type="text" class="form-control" id="_status" name="_status"   placeholder="Nombre del evento..." readonly="readonly">
                                                    </div>
                                            </div>

                                            
                                            
                                            <div class="row" >
                                                <div id="novoucher" style="display:none;">
                                                   
                                                        <label class="col-sm-4 control-label">
                                                            Comprobante:*
                                                        </label>

                                                        <div class="col-sm-8" >
                                                            <div class="fileinput fileinput-new" data-provides="fileinput">
                                                                <span class="btn btn-default btn-file">
                                                                <span class="fileinput-new"><i class="glyph-icon icon-paperclip"></i> Adjuntar archivo</span>
                                                                <span class="fileinput-exists">Cambiar</span>
                                                                    <input type="file" id="file" name="file" accept="application/pdf,image/jpg,image/jpeg,image/png">
                                                                </span>
                                                                <span class="fileinput-filename"></span>
                                                                <a href="#" class="close fileinput-exists" data-dismiss="fileinput" style="float: none">×</a>
                                                            </div>
                                                            <input type="hidden" id="imageName" name="imageName" value=""/>
                                                            <input type="hidden" id="contentType" name="contentType" value=""/>
                                                            <input type="hidden" id="imageData" name="imageData" value=""/>
                                                            <input type="hidden" id="sizeData" name="sizeData" value=""/>
                                                        </div>
                                                </div>
                                                <div id="yesvoucher" style="display:none;">
                                                    <label class="col-sm-4 control-label">
                                                        Comprobante:
                                                    </label>
                                                    <div class="col-sm-8" >
                                                        <a href="" id="voucherfile" target="blank" class="btn btn-xs btn-alt btn-hover btn-blue-alt"><span>Ver</span><i class="glyph-icon icon-arrow-right"></i></a>
                                                    </div>
                                                </div>
                                                   
                                            </div>

                                            <div id="pago" style="display:none;">
                                                <div class="row" >
                                                    <label class="col-sm-4 control-label">
                                                        Tipo de pago:*</label>
                                                    <div class="col-sm-8">
                                                        <select class="form-control" id="payment_type" name="payment_type">
                                                            <option value="">-Selecciona-</option>
                                                                @foreach($payment_type as $payment_types)
                                                                    <option value="{{$payment_types->id}}">{{$payment_types->payment_name}}</option>
                                                                @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <p style="font-size:12px;"><em>(*) Estos campos son requeridos para poder confirmar su pago.</em></p>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                       
                                                    
                                        </div>

                               

                                            <div class="col-md-5 col-md-offset-1">
                                                <div class="row" id="invitadoscampos">
                                                    <div class="scrollable-content scrollable-xs">

                                                        <div class="input-group form-guess">
                                                            <span class="btn btn-md btn-primary" id="btnaddguest2">
                                                                <i class="glyph-icon icon-plus"></i>
                                                                Añadir invitados externos
                                                            </span>
                                                            <!--<input type="text" class="form-control" id="guestcero" name="name_guest2[]" placeholder="Nombre del invitado">-->
                                                        </div>
                                                        

                                                        <div id="addguest2">
                                                        </div>
                                                        <div id="fieldguestadd2">
                                                        </div>
                                                               
                                                                
                                                    </div>
                                                </div>
                                            </div>
                                               
                                    </div>

                                </div>
                            </div>
                        </div>

                </div>

                <div id="bodymodaleliminar" style="display:none;">
                    <p style="padding-left:20px; padding-right:20px;padding-bottom:20px;">¿Esta seguro que desea eliminar esta reservación?</p>
                </div>
                       
            </div>
                        
            <div class="modal-footer">

                <div id="footermodal">
                    <div style="display:inline-block;">
                        <button type="button" class="btn btn-dafault" data-dismiss="modal" id="closemodalsolo">Cerrar</button>
                    </div>
                    <div id="btnseditarres" style="display:inline-block;">
                        <a id="btndeletemodal" class="btn btn-danger">Eliminar</a>
                       
                        
                    </div>
                    <div  id="btnguardartodo" style="display:inline-block;">
                        <a id="update" data-href="{{ url('/reservation/resident') }}" data-id="" class="btn btn-success">Guardar</a> 
                    </div>      
                        <div style="display:none;">
                            <button type="submit" id="btnsubmitform"></button>
                        </div>
                    
                      
                </div>

                <div id="footermodaleliminar" style="display:none;">

                    <button type="button" id="btncerrareliminar2" class="btn btn-dafault" data-dismiss="modal">Cerrar</button>
                    <a id="delete" data-href="{{ url('reservation/resident') }}" data-id="" class="btn btn-danger">Eliminar</a>
                </div>

            </div>
            
            </div>
        </form>
    </div>
</div>



<!-- Calendar -->
{!! Html::script('vendor/moment/min/moment.min.js') !!}
{!! Html::script('vendor/fullcalendar/fullcalendar.min.js') !!}
{!! Html::script('vendor/fullcalendar/locale/es.js') !!}
{!! Html::script('vendor/fullcalendar/lib/moment.min.js') !!}
{!! Html::script('vendor/compress.js/src/Compress.js') !!}
{!! Html::script('vendor/compress.js/index.js') !!}
{!! Html::script('js/validaciones.js') !!}
<!--<script type="text/javascript" src="../../../assets/widgets/calendar/calendar-demo.js"></script>-->

<script>
    window.onload = function() {
        var myInput = document.getElementById('date');
        myInput.onpaste = function(e) {
            e.preventDefault();
            alert("No puedes copiar y/o pegar en este campo.");
        }
        
        myInput.oncopy = function(e) {
            e.preventDefault();
            alert("No puedes copiar y/o pegar en este campo.");
        }

        myInput.oncut = function(e) {
            e.preventDefault();
            alert("No puedes copiar y/o pegar en este campo.");
        }
    }

    comprimirImagen('file');

    var BASEURL = "{{ url('/') }}";
    
    function MM_openBrWindow(theURL,winName,features) { //v2.0
        window.open(theURL,winName,features);
    }

    function pulsar(e) { 
        tecla = (document.all) ? e.keyCode :e.which; 
        return (tecla!=13); 
    } 

    $(document).ready(function() { 

        $('#date').keypress(function(tecla){
    
           if(tecla.charCode < 48 || tecla.charCode > 57)return false;
           if ((tecla.charCode < 97 || tecla.charCode > 122)//letras mayusculas
                    && (tecla.charCode < 65 || tecla.charCode > 90) //letras minusculas
                    && (tecla.charCode != 45) //retroceso
                    && (tecla.charCode != 241) //ñ
                     && (tecla.charCode != 209) //Ñ
                     && (tecla.charCode != 32) //espacio
                     && (tecla.charCode != 225) //á
                     && (tecla.charCode != 233) //é
                     && (tecla.charCode != 237) //í
                     && (tecla.charCode != 243) //ó
                     && (tecla.charCode != 250) //ú
                     && (tecla.charCode != 193) //Á
                     && (tecla.charCode != 201) //É
                     && (tecla.charCode != 205) //Í
                     && (tecla.charCode != 211) //Ó
                     && (tecla.charCode != 218) //Ú
     
                  )
            return false; 

        });
    });

</script>
<!--{!! Html::script('js/reservations.js') !!}-->
<script>
    $(document).ready(function() {
    
    	$('tr#trres').each(function(i){
            
        	var n = i+1;
            $('#aprobarres'+n).on('click', function(){
    
            	//$('#paytipo > option:selected').removeAttr('selected');
            	
                //$('option', select).removeAttr('selected');
                //$('#paytipo option:selected').attr("selected",false);
               
                $('#tipopagoresidente').empty();
                var id = $('#aprobarres'+n).attr("value");
                var tipo = $("#idpago"+n).val();
                $('#aproveid').attr("value",id);
                $('#tipopagoresidente').append("Tipo de pago seleccionado por el residente: "+tipo);
    
                //$("#paytipo > option[value="+tipo+"]").attr('selected','selected');
                
    
            });
    
            $('#rechazarres'+n).on('click', function(){
                  
                var idS = $('#rechazarres'+n).attr("value");
                
                $('#rejectid').attr("value",idS);
    
            });
    
    
        });
    
    	var next2 = 0;
    	$('#btnaddguest2').on('click', function(){
    		
    		next2++;
    		addnumber = '<div class="input-group form-guess" id="fieldguestadd2'+next2+'"><span class="input-group-addon addon-inside btn-danger msg-warning" id="deletefield2'+next2+'"><i class="glyph-icon icon-times"></i></span><input type="text" class="form-control" id="guest'+next2+'" name="name_guest2[]" onkeypress="return pulsar(event)" placeholder="Nombre del invitado externo" required></div>';
    		$('#addguest2').append(addnumber);
    
    		var i = next2;
    		$('#deletefield2'+i).on('click', function(){
    			$('div#fieldguestadd2'+i).remove();
    		});
    		
    	});
    
    	var next = 0;
    	$("#btnaddguest").on('click', function(){
    
    		next++;
    		addguest = '<div class="input-group form-guess" id="fieldguest'+next+'"><span class="input-group-addon addon-inside btn-danger msg-warning" id="deletefield'+next+'"><i class="glyph-icon icon-times"></i></span><input type="text" class="form-control" name="guest[]" onkeypress="return pulsar(event)" placeholder="Nombre del invitado externo" required></div>';
    		$('#guests').append(addguest);
    
    		var i = next;
    		$('#deletefield'+i).on('click', function(){
    			$('div#fieldguest'+i).remove();
    		});
    
    	});
    
    	$("#btnagregarevento").on('click', function(){
    
    		var uno = $("#btnagregarevento").attr("class");
    		//alert(uno);
    		
    		if(uno == "btn btn-md btn-danger collapsed")
    		{
    			$("#btnagregarinvitado").show();
    			$("#iconagregar").attr("class","glyph-icon icon-minus");
    
    		}
    		else
    		{
    			
    			$("#btnagregarinvitado").hide();
    			$("#iconagregar").attr("class","glyph-icon icon-plus");
    		}
    		
    	});
    
    
    	/*$("#btnagregarinvitado").on('click', function(){
    
    		var dos = $("#demo-3").attr("class");
    
    		if(dos == "collapse in")
    		{
    			
    			$("#inputguest").attr("required", false);
    		}
    		else
    		{
    			$("#inputguest").attr("required", true);
    		}
    		
    	});*/
    });
</script>
<!--{!! Html::script('js/calendar.js') !!}-->
<script>
    $(document).ready(function() {
               
        var mes = $('#month').val();
    
        $('#calendar').fullCalendar({
                    
            defaultView: 'month',
            lang: 'es',
                    
            viewRender: function(currentView){
                var minDate = moment(),
                maxDate = moment().add(mes,'months');
                // Past
                if (minDate >= currentView.start && minDate <= currentView.end) {
                    $(".fc-prev-button").prop('disabled', true); 
                    $(".fc-prev-button").addClass('fc-state-disabled'); 
                }
                else {
                    $(".fc-prev-button").removeClass('fc-state-disabled'); 
                    $(".fc-prev-button").prop('disabled', false); 
                }
                // Future
                if (maxDate >= currentView.start && maxDate <= currentView.end) {
                    $(".fc-next-button").prop('disabled', true); 
                    $(".fc-next-button").addClass('fc-state-disabled'); 
                } else {
                    $(".fc-next-button").removeClass('fc-state-disabled'); 
                    $(".fc-next-button").prop('disabled', false); 
                }
            },
                    
            header: {
                left: 'prev,next today',
                center: 'title',
                right: 'month,basicWeek,basicDay'
            },
    
                    
            navLinks: true, // can click day/week names to navigate views
            editable: true,
            selectable: true,
            selectHelper: true,
    
            events: BASEURL + '/events',
    
            eventClick: function(event, jsEvent, view){
    
                res = $('#reservation_active').val();
                $('#message_status').empty();
                /*if(res == 0)
                {
    
                    $("#invitadoscampos").hide();
                    $("#btnguardartodo").hide();
                    $("#btnseditarres").hide("slow");
                }
                else
                {*/
                    user = $("#user").attr("value");
                    if(user == event.residence_id)
                    {
                        $("#btnguardartodo").show("slow");
                        $("#invitadoscampos").show("slow");
                        if(event.stname == "reservado")
                        {   // #Boton cancelar en evento gratuito
                            if(event.cost !==0){
                            $("#btnseditarres").hide("slow");
                            }
                            $("#novoucher").hide();
                            $("#yesvoucher").hide();
                            $("#pago").hide("slow");
                            $('#message_status').empty();
    
                        }
                        else
                        {
                           
                            $("#btnseditarres").show("slow");
                            text = '<div class="alert alert-warning">Aun no ha sido aprobada por el administrador.</div>';
                            $('#message_status').append(text);
                            if(event.payment_type === null)
                            {
                                $("#pago").show("slow");
                                $("#confpago").show("slow");
                            }
                            else
                            {
                                $("#pago").hide("slow");
                                $("#confpago").hide("slow");
                            }
    
                            if(event.url_voucher !== null)
                            {
                                $("#novoucher").hide();
                                $('#modal-event #voucherfile').attr("href", event.url_voucher);
                                $("#yesvoucher").show();
                                $("#confpago").hide("slow");
                            }
                            else
                            {
                                        
                                $("#yesvoucher").hide();
                                $("#novoucher").show();
                                $("#confpago").show("slow");
                            }
                        }
                    }
                    else
                    {
                        $("#btnseditarres").hide("slow");
                        $("#novoucher").hide();
                        $("#yesvoucher").hide();
                        $("#btnguardartodo").hide();
                        $("#invitadoscampos").hide();
                        $("#pago").hide("slow");
                        
                    }
                //}
    
                var fecha = new Date().toJSON().slice(0,10);
                $.get('/ajax/guests/access/'+event.id, function(data){
                                                         
                    if(data == 1)
                    {
                        $("#btndeletemodal").hide();
                        //$("#guestcero").attr("required",true);
                    }
                    else if(data === 0)
                    {
                        if(event.date < fecha)
                        {
                            $("#btndeletemodal").hide();
                        }
                        else
                        {
                            $("#btndeletemodal").show();
                        }
                    }
                    
                });
                   
    
                $('#fieldguestadd').empty();
                $('#fieldguestadd2').empty();
                $("#btnaddg").show();
    
                $('#modal-event #delete').attr('data-id', event.id);
                $('#modal-event #update').attr('data-id', event.id);
                //$('#modal-event #confpago').attr('data-id', event.id);
                $('#modal-event #_title').val(event.title);
                $('#modal-event #_social_area').val(event.name_social_area);
                $('#modal-event #_date').val(event.date);
                $('#modal-event #_time_start').val(event.time_start);
                $('#modal-event #_time_end').val(event.time_end);
                $('#modal-event #_status').val(event.status_name);
                
    
                $.get('/ajax/guests/'+event.id, function(data){
                                                         
                    if(data == 1)
                    {
                        $("#btnaddg").hide();
                        
                    }
                    else
                    {
                        next = 0;
                        $.each(data, function(index, subcatObj){
                            next++;
                            camp = '<div class="input-group form-guess" id="fieldguest'+next+'"><span class="input-group-addon addon-inside btn-danger msg-warning" id="deletefields'+next+'"><i class="glyph-icon icon-times"></i></span><input type="text" id="guest'+next+'" name="name_guest[]" value="'+subcatObj.name_guest+'" class="form-control" readonly="readonly"><input type="hidden" name="id_guest[]" value="'+subcatObj.id+'"/></div>';
                            $('#fieldguestadd2').append(camp);
    
                            var i = next;
                            $('#deletefields'+i).on('click', function(){
                                $('div#fieldguest'+i).remove();
                            });
                        });
                        
                     }
                           
                });
    
                $('#modal-event').modal('show');
                        
    
            }
                
        });
    
                   
        $('#delete').on('click', function(){
            var x = $(this);
            var delete_url = x.attr('data-href')+'/'+x.attr('data-id');
                    
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: delete_url,
                type: 'DELETE',
                success: function(result){
                    $('#modal-event').modal('hide');
                    location.reload();
                },
                error: function(result){
                    $('#modal-event').modal('hide');
                    location.reload();
                }
            });
        });
    
        $('#update').on('click', function(){
    
            
    
             var vou = $('#payment_type option:selected').attr("value");
    
        if($("#file").val().length > 1 && vou > 0)
        {
            var x = $(this);
            var update_url = x.attr('data-href')+'/'+x.attr('data-id');          
            $('#formupdateevent').attr("action",update_url);
            //$('#formupdateevent').submit();
             $('#btnsubmitform').click();
    
        }
        else
        {
            if($("#file").val().length > 1)
            {
                
                alert("Falta seleccionar el tipo de pago");
            }
            else if(vou > 0)
            {
                alert("Falta subir el comprobante de pago.");
            }
            else
            {   
                x = $(this);
                update_url = x.attr('data-href')+'/'+x.attr('data-id');          
                $('#formupdateevent').attr("action",update_url);
                //$('#formupdateevent').submit();
                 $('#btnsubmitform').click();
            }
            
            /**/
        }
    
         
        });
    
        $('#confpago').on('click', function(){
    
        
           /*$('#payment_type').attr("required",true);
            $('#file').attr("required",true);*/
    
            var x = $(this);
            var update_url = x.attr('data-href')+'/'+x.attr('data-id');          
            $('#formupdateevent').attr("action",update_url);
    
            $('#btnsubmitcomprobante').click();
        });
    
        var mes2 = $('#month').attr("value");
        var dia = $('#dia').attr("value");
        var dateLimit = $('#dateLimit').attr("value");
    
        $('#date').datepicker({
        
            onSelect: function(dateText, inst) {
                $("#acept_reservation").attr("disabled", false);
                var day = moment(dateText).format("d");
                $("#day_select").attr("value",day);
            },
            minDate: '0d',
            maxDate: dateLimit,
            //maxDate: '+'+mes2+'m'            
            //maxDate: '+'+mes2+'m -'+dia+'d',
    
        });
    
        $('#socialarea').on('change', function(){
            
            var ids = $('#socialarea option:selected').attr("value");
            $("#acept_reservation").attr("disabled", false);
    
             $.get('/ajax/cost_social_area/'+ids, function(data){
                                                         
                $.each(data, function(index, subcatObj){
                    
                    if(subcatObj.cost == 0)
                    {
                        $('#gruopcost').hide("slow");
                        //$('#payment_type').attr("required",false);
                        $('#monday').val(' ');
                        $('#tuesday').val(' ');
                        $('#wendsday').val(' ');
                        $('#thursday').val(' ');
                        $('#friday').val(' ');
                        $('#saturday').val(' ');
                        $('#sunday').val(' ');
                        $('#monday').val(subcatObj.monday);
                        $('#tuesday').val(subcatObj.tuesday);
                        $('#wendsday').val(subcatObj.wendsday);
                        $('#thursday').val(subcatObj.thursday);
                        $('#friday').val(subcatObj.friday);
                        $('#saturday').val(subcatObj.saturday);
                        $('#sunday').val(subcatObj.sunday);
                        $('#cost').val(' ');
                    }
                    else
                    {
                        $('#cost').val(subcatObj.cost);
                        $('#monday').val(subcatObj.monday);
                        $('#tuesday').val(subcatObj.tuesday);
                        $('#wendsday').val(subcatObj.wendsday);
                        $('#thursday').val(subcatObj.thursday);
                        $('#friday').val(subcatObj.friday);
                        $('#saturday').val(subcatObj.saturday);
                        $('#sunday').val(subcatObj.sunday);
                        $('#gruopcost').show("slow");
                    }
    
                    if(subcatObj.url_file != null)
                    {
                        $('#reglamentofile').attr("href", subcatObj.url_file);
                        $('#reglamento').show("slow");
                    }
                    else
                    {
                        $('#reglamentofile').attr("href", ' ');
                        $('#reglamento').hide("slow");
                    }
                         
                    
                });
    
     
            });
    
        });
    
    var ids = $('#socialarea option:selected').attr("value");
            $("#acept_reservation").attr("disabled", false);
    
             $.get('/ajax/cost_social_area/'+ids, function(data){
                                                         
                $.each(data, function(index, subcatObj){
                    
                    if(subcatObj.cost == 0)
                    {
                        $('#gruopcost').hide("slow");
                        //$('#payment_type').attr("required",false);
                        $('#monday').val(' ');
                        $('#tuesday').val(' ');
                        $('#wendsday').val(' ');
                        $('#thursday').val(' ');
                        $('#friday').val(' ');
                        $('#saturday').val(' ');
                        $('#sunday').val(' ');
                        $('#monday').val(subcatObj.monday);
                        $('#tuesday').val(subcatObj.tuesday);
                        $('#wendsday').val(subcatObj.wendsday);
                        $('#thursday').val(subcatObj.thursday);
                        $('#friday').val(subcatObj.friday);
                        $('#saturday').val(subcatObj.saturday);
                        $('#sunday').val(subcatObj.sunday);
                        $('#cost').val(' ');
                    }
                    else
                    {
                        $('#cost').val(subcatObj.cost);
                        $('#monday').val(subcatObj.monday);
                        $('#tuesday').val(subcatObj.tuesday);
                        $('#wendsday').val(subcatObj.wendsday);
                        $('#thursday').val(subcatObj.thursday);
                        $('#friday').val(subcatObj.friday);
                        $('#saturday').val(subcatObj.saturday);
                        $('#sunday').val(subcatObj.sunday);
                        $('#gruopcost').show("slow");
                    }
    
                    if(subcatObj.url_file != null)
                    {
                        $('#reglamentofile').attr("href", subcatObj.url_file);
                        $('#reglamento').show("slow");
                    }
                    else
                    {
                        $('#reglamentofile').attr("href", ' ');
                        $('#reglamento').hide("slow");
                    }
                         
                    
                });
    
     
            });
    
    $('#btndeletemodal').on('click', function(){
    
        $('#modalheader').hide("slow");
        $('#bodymodal').hide("slow");
        $('#footermodal').hide("slow");
        $('#modalheadereliminar').show("slow");
        $('#bodymodaleliminar').show("slow");
        $('#footermodaleliminar').show("slow");
    
    });
    
    $('#btncerrareliminar').on('click', function(){
    
        $('#modalheader').show("slow");
        $('#bodymodal').show("slow");
        $('#footermodal').show("slow");
        $('#modalheadereliminar').hide("slow");
        $('#bodymodaleliminar').hide("slow");
        $('#footermodaleliminar').hide("slow");
    });
    
    $('#btncerrareliminar2').on('click', function(){
    
        $('#modalheader').show("slow");
        $('#bodymodal').show("slow");
        $('#footermodal').show("slow");
        $('#modalheadereliminar').hide("slow");
        $('#bodymodaleliminar').hide("slow");
        $('#footermodaleliminar').hide("slow");
    });
    
    $('#closemodalsolo').on('click',function(){
    
        $('#payment_type option:selected').attr('selected', false);
        $('#payment_type> option[value=""]').attr('selected', 'selected');
        $('#file').val('');
        $('#payment_type').attr('value',"");
        $("div#addguest2").empty();
    
    });
    
    $('#closetachitamodal').on('click',function(){
    
        $('#payment_type option:selected').attr('selected', false);
        $('#payment_type> option[value=""]').attr('selected', 'selected');
        $('#file').val('');
        $('#payment_type').attr('value',"");
        $("div#addguest2").empty();
    
    });
    
    $('#acept_reservation').on("click", function(){
    
        
            day_start = $('#day_select').attr("value");
            monday = $("#monday").attr("value");
            tuesday = $("#tuesday").attr("value");
            wendsday = $("#wendsday").attr("value");
            thursday = $("#thursday").attr("value");
            friday = $("#friday").attr("value");
            saturday = $("#saturday").attr("value");
            sunday = $("#sunday").attr("value");
    
            var ids = $('#socialarea option:selected').attr("value");
            var date = $('#date').val();
            $.get('/getreservday?id='+ids+'&&date='+date, function(data){
    
                /*if(data == 0)
                {
                    //$("#acept_reservation").attr("disabled", true);
                    alert("No se puede reservar el evento porque ya existe una reservación en el area social seleccionada ese día.");
    
                }*/
                //else
                //{
                    if(day_start == "1")
                    {
                        if(monday == 1)
                        {
                            $("#aceptarreservas").click();
                        }
                        else
                        {
                            $("#acept_reservation").attr("disabled", true);
                            alert("El area social seleccionada no se puede separar en lunes.");
                        }
                    }
                    else if(day_start == "2")
                    {
                        if(tuesday == 1)
                        {
                            $("#aceptarreservas").click();
                        }
                        else
                        {
                            $("#acept_reservation").attr("disabled", true);
                            alert("El area social seleccionada no se puede separar en martes.");
                        }
                    }
                    else if(day_start == "3")
                    {
                        if(wendsday == 1)
                        {
                            $("#aceptarreservas").click();
                        }
                        else
                        {
                            $("#acept_reservation").attr("disabled", true);
                            alert("El area social seleccionada no se puede separar en miércoles.");
                        }
                    }
                    else if(day_start == "4")
                    {
                        if(thursday == 1)
                        {
                            $("#aceptarreservas").click();
                        }
                        else
                        {
                            $("#acept_reservation").attr("disabled", true);
                            alert("El area social seleccionada no se puede separar en jueves.");
                        }
                    }
                    else if(day_start == "5")
                    {
                        if(friday == 1)
                        {
                            $("#aceptarreservas").click();
                        }
                        else
                        {
                            $("#acept_reservation").attr("disabled", true);
                            alert("El area social seleccionada no se puede separar en viernes.");
                        }
                    }
                    else if(day_start == "6")
                    {
                        if(saturday == 1)
                        {
                            $("#aceptarreservas").click();
                        }
                        else
                        {
                            $("#acept_reservation").attr("disabled", true);
                            alert("El area social seleccionada no se puede separar en sábado.");
                        }
                    }
                    else if(day_start == "0")
                    {
                        if(sunday == 1)
                        {
                            $("#aceptarreservas").click();
                        }
                        else
                        {
                            $("#acept_reservation").attr("disabled", true);
                            alert("El area social seleccionada no se puede separar en domingo.");
                        }
                    }
                    else
                    {
                        $("#aceptarreservas").click();
                    }
                //}
            });
    
    });
       
    });
</script>

@include('footer')

@endsection