<?php

use App\Colony;
use App\LogoColony;
use Carbon\Carbon;
use App\Status;
use App\Reservation;
use App\Street;
use App\User;
use App\AccessColony;
use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {

  if (Auth::check()) {
    return redirect('/home');
  } else {
    return view('auth.login');
  }
});

Route::get('/download/{file}', 'DescargarQr@descargar');
Route::resource('/qrreader', 'ReadQRController');


Auth::routes();

Route::get('/home', 'HomeController@index');
Route::get('/redirect', 'SocialAuthController@redirect');
Route::get('/callback', 'SocialAuthController@callback');

//Route::get('/ajax/cost_social_area/{$id}', 'AjaxCostSocialArea@show');
Route::get('ajax/cost_social_area/{id}', array('uses' => 'AjaxController@show'));


Route::resource('/history_resident', 'AjaxHistoryResidentController');

Route::resource('/accountdetail', 'AccountDetailController');

Route::resource('/configuration/streets', 'StreetController')->names('streetsConfig');
Route::resource('/configuration/colony', 'ColonyController');
Route::resource('/bank', 'AccountController');
Route::resource('/transfer_account', 'TransferAccountController');
Route::resource('/configuration/income_concepts', 'IncomeConceptController');
Route::resource('/configuration/expense_concepts', 'ExpenseConceptController');
Route::resource('/configuration/guard_info', 'GuardInfoController');
Route::resource('/configuration/config', 'ConfigController');
Route::resource('/configuration/social_areas', 'SocialAreaController');
Route::resource('/configuration/support_form', 'SupportFormController');
Route::resource('/configuration/email_template', 'EmailTemplateController');
//Route::resource('/configuration/resident_permission', 'ResidentPermissionController');
Route::resource('/configuration/perfil_config', 'PerfilConfigController');
Route::resource('/configuration/users', 'UserController');
Route::resource('/configuration/users/changepassword', 'ChangePasswordController')->names('user');

Route::resource('/configuration/guard/changepassword', 'ChangePasswordVigController')->names('guard');

Route::resource('/configuration/resident/changepassword', 'ChangePasswordResController')->names('resident');
Route::resource('/configuration/popup', 'PopupController');
Route::resource('/configuration/logo_colony', 'LogoColonyController');
Route::resource('/status_account', 'AccountStatusController');
Route::resource('/info', 'InfoController');

Route::resource('/configuration/license_software', 'LicenseSoftwareController');

Route::resource('/incomes/residents', 'IncomeResidentController');
Route::resource('/incomes/resident_update', 'UpdateIncomeResidentController');
Route::resource('/incomes', 'IncomeController');
Route::resource('/incomes_bc', 'EditIncomeController');
Route::resource('/accountstopay', 'AccountToPayController');
Route::resource('/accounts_receivables', 'AccountToPayAdminController');
Route::resource('/extraordinary_accounts', 'ExtraordinaryAccountController');
Route::resource('/details_pay', 'DetailsPaymentResidentController');

Route::resource('/expenses', 'ExpenseController');
Route::resource('/directory', 'DirectoryController');
Route::resource('/directory_admin', 'DirectoryAdminController');


Route::resource('events', 'EventController');
Route::resource('eventadmin', 'EventAdminController');
Route::resource('eventguard', 'EventGuardController');
Route::resource('eventworkers', 'EventWorkersController');
Route::resource('eventworkersres', 'EventWorkerResController');

Route::resource('/ajax/guests', 'AjaxGuestReservationController')->names('guests');
Route::resource('/ajax/guests/access', 'AjaxGuestAccessController')->names('guestsAccess');
Route::resource('/ajax/event/date', 'AjaxGuestAccessController')->names('eventdate');
Route::resource('/ajax/streets', 'AjaxStreetController')->names('streets');
Route::resource('/ajax/socialareas', 'AjaxSocialAreasController')->names('socialareas');


Route::resource('/reservations', 'ReservationAdminController')->names('reservations');
Route::resource('/reservation/resident', 'ReservationResController')->names('reservationsRes');
Route::resource('/roles', 'RolController');

Route::resource('/messages', 'MessageController')->names('messages');
Route::resource('/message/resident', 'MessageResController')->names('messageRes');

Route::resource('/documents', 'DocumentController')->names('documents');

Route::resource('/document/resident', 'DocumentResController')->names('documentRes');

Route::resource('/employes', 'EmployeController');

Route::resource('/configurations', 'ConfigMasterController');

Route::resource('/change_email', 'ChangeEmailController');

Route::resource('/dashboard_resident', 'DashboardResController');
Route::resource('/dashboard_admin', 'DashboardAdminController');
Route::resource('/dashboard_guard', 'DashboardGuardController');
Route::resource('/guard_visit', 'GuardRegisterVisitController');

Route::resource('/report_resident', 'ReportResController');
Route::resource('/report_admin', 'ReportAdminController');

Route::resource('/access_colony', 'AccessColonyController');
Route::resource('/access_visit', 'VisitController');
Route::resource('/recurrent_employe', 'RecurrentEmployeController');
Route::resource('/visitcheck', 'VisitCheckController');


Route::resource('/employe_info', 'EmployeInfoController');
Route::resource('/employe_visit', 'EmployeVisitController');
Route::resource('/add_photo', 'AddPhotoEmployeController');

Route::resource('/prueba', 'ImagenPruebaController');

Route::resource('/discussions', 'DiscussionController');
Route::resource('/discussions_resident', 'DiscussionResController');
Route::resource('/monthly_contribution', 'MonthlyPayController');
Route::resource('/contribution_asign', 'MonthlyPayAsignController');

Route::get('/getstreetwithuser', function () {

  $Busqueda = request()->term;

  $street = DB::select('select streets.id as street_id,name_street,number FROM streets 
      JOIN  users ON street_id = streets.id
      WHERE empty_residence = "0" AND concat_ws(" ",name_street,number) LIKE "%' . $Busqueda . '%" AND ISNULL(deleted_at)');

  if (empty($street)) {
    $return_array[] = array('value' => "No se encuentra la residencia.", 'id' => " ");
  } else {
    foreach ($street as $streets) {

      $return_array[] = array('value' => $streets->name_street . " " . $streets->number, 'id' => $streets->street_id);
    }
  }


  //return json_encode($return_array);
  return Response::json($return_array);
});


Route::get('/ajax/ambiguosreservation', function () {

  $date = request()->date;
  $start = request()->start;
  $end = request()->end;
  $social = request()->social;


  $_start = "'" . $start . ":00'";
  $_end = "'" . $end . ":00'";

  $ambigous = DB::select('select id FROM reservations WHERE date = ' . $date . ' AND (' . $_start . ' BETWEEN time_start AND reservations.time_end AND ' . $_end . ' BETWEEN time_start AND reservations.time_end) AND social_area = ' . $social . '');


  if (empty($ambigous)) {
    return 1;
  } else {
    return 0;
  }
});

Route::get('/getstreets', function () {

  $Busqueda = request()->term;

  $street = DB::select('select * FROM streets WHERE empty_residence = "0" AND concat_ws(" ",name_street,number) LIKE "%' . $Busqueda . '%" AND ISNULL(deleted_at) ');

  if (empty($street)) {
    $return_array[] = array('value' => "No se encuentra la residencia.", 'id' => " ");
  } else {
    foreach ($street as $streets) {

      $return_array[] = array('value' => $streets->name_street . " " . $streets->number, 'id' => $streets->id);
    }
  }


  //return json_encode($return_array);
  return Response::json($return_array);
});


Route::get('/getstreets2', function () {

  $Busqueda = request()->term;

  $street = DB::select('select * FROM streets WHERE concat_ws(" ",name_street,number) LIKE "%' . $Busqueda . '%" AND ISNULL(deleted_at)');

  if (empty($street)) {
    $return_array[] = array('value' => "No se encuentra la residencia.", 'id' => " ");
  } else {
    foreach ($street as $streets) {

      $return_array[] = array('value' => $streets->name_street . " " . $streets->number, 'id' => $streets->id);
    }
  }


  //return json_encode($return_array);
  return Response::json($return_array);
});

Route::get('/getnameemploye', function () {

  $Busqueda = request()->term;
  $id = request()->valpasa;

  $name = DB::select('select id,name FROM employes WHERE residence_id = "' . $id . '" AND concat_ws(" ",name) LIKE "%' . $Busqueda . '%" AND ISNULL(deleted_at)');

  if (empty($name)) {
    $return_array[] = array('value' => "No se encuentra el empleado.", 'id' => " ");
  } else {
    foreach ($name as $names) {

      $return_array[] = array('value' => $names->name, 'id' => $names->id);
    }
  }


  //return json_encode($return_array);
  return Response::json($return_array);
});

Route::get('/getnamevisit', function () {

  $Busqueda = request()->term;
  $id = request()->valpasa;



  $visit = DB::select('select id,name FROM visits WHERE residence_id = "' . $id . '" AND concat_ws(" ",name) LIKE "%' . $Busqueda . '%" AND ISNULL(deleted_at)');

  if (empty($visit)) {
    $return_array[] = array('value' => "No se encuentra el visitante.", 'id' => " ");
  } else {
    foreach ($visit as $visits) {

      $return_array[] = array('value' => $visits->name, 'id' => $visits->id);
    }
  }


  //return json_encode($return_array);
  return Response::json($return_array);
});







Route::get('/getreservday', function () {

  $area = request()->id;

  //$status = DB::select('select id FROM status WHERE name = "cancelado"');
  $status = Status::where('name', "cancelado")->first();
  $date = request()->date;

  $reservation = Reservation::where('social_area', $area)
    ->where('date', $date)
    ->where('reservation_status', '!=', $status->id)
    ->get();


  if ($reservation->isEmpty()) {
    $dat = 1;
  } else {
    $dat = 0;
  }

  return $dat;
});

Route::get('/getstreetsresidence', function () {

  $Busqueda = request()->term;



  $street = DB::select('select name_street,number,streets.id,name FROM streets
          JOIN users ON streets.id = street_id 
          WHERE empty_residence = "0"
          AND (concat_ws(" ",name_street,number) LIKE "%' . $Busqueda . '%" 
          OR concat_ws(" ",name) LIKE "%' . $Busqueda . '%") 
          AND ISNULL(deleted_at)');

  if (empty($street)) {
    $return_array[] = array('value' => "No se encuentra la residencia.", 'id' => " ");
  } else {
    foreach ($street as $streets) {


      $return_array[] = array('value' => $streets->name_street . " " . $streets->number . " " . $streets->name, 'id' => $streets->id);
    }
  }


  //return json_encode($return_array);
  return Response::json($return_array);
});



Route::get('/getdirectory', function () {

  $Busqueda = request()->term;

  $street = DB::select('select name_street,number,streets.id,name FROM users
          JOIN streets ON streets.id = street_id
          LEFT JOIN perfil_configs ON user_id = users.id
          WHERE private_profile = "1"
          AND empty_residence = "0"
          AND (concat_ws(" ",name_street,number) LIKE "%' . $Busqueda . '%" 
          OR concat_ws(" ",name) LIKE "%' . $Busqueda . '%")');

  if (empty($street)) {
    $return_array[] = array('value' => "No se encuentra la residencia.", 'id' => " ");
  } else {
    foreach ($street as $streets) {


      $return_array[] = array('value' => $streets->name_street . " " . $streets->number . " " . $streets->name, 'id' => $streets->id);
    }
  }


  //return json_encode($return_array);
  return Response::json($return_array);
});

Route::get('/getstreetuser', function () {

  $Busqueda = request()->term;

  $street = DB::select('select name_street,number,id FROM streets 
          WHERE empty_residence = "0"
          AND streets.id NOT IN (select street_id FROM users WHERE hidden = "0")
          AND (concat_ws(" ",name_street,number) LIKE "%' . $Busqueda . '%")');

  if (empty($street)) {
    $return_array[] = array('value' => "No se encuentra la residencia.", 'id' => " ");
  } else {
    foreach ($street as $streets) {


      $return_array[] = array('value' => $streets->name_street . " " . $streets->number, 'id' => $streets->id);
    }
  }


  //return json_encode($return_array);
  return Response::json($return_array);
});


Route::get('/app/{user}/{pass}', function ($user, $pass) {

  //$email = User::where('email',$user)->first();

  $email = User::where('email', $user)->get();



  if ($email->isEmpty()) {
    $return = "null";
    return $return;
  } else {

    foreach ($email as $emails) {
      $password = $emails->password;
    }
    if (Hash::check($pass, $password)) {

      $em = User::select('email')->where('email', $user)->get();
      return $em;
    } else {
      $return = "null";
      return $return;
    }
  }
});

Route::get('/checkatribution', function () {

  $Busqueda = request()->a_id;

  $street = DB::select('select id FROM streets WHERE empty_residence = "0"
          AND contribution = "' . $Busqueda . '"');

  if (empty($street)) {

    $return = 1;
  } else {

    $return = 0;
  }


  return Response::json($return);
});




Route::resource('QRreader', 'ApiVigilanteController');














//Route::get('/history_resident/{$id}', array('uses'=>'AjaxController@getHistoryResident'));
//Route::get('ajax/estados/{id}', array('uses'=>'AjaxController@getEstados'));