<?php $__env->startSection('content'); ?>

<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Bancos y cajas</h2>
            <p>Edita los bancos y cajas</p>
        </div>
    </div>
                
    <!--Fecha-->
    <?php echo $__env->make('date', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

</div><!--BREADCRUMB END-->

<?php echo $__env->make('sessionmessage', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php if($errors->has('error')): ?>
    <div class="alert alert-danger">
        <ul>    
            <li><?php echo e($errors->first('error')); ?></li>         
        </ul>
    </div>                                             
<?php endif; ?>


<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Editar cuenta
        </h3>
                    
        <div class="example-box-wrapper">
            <div class="row">
               <?php echo Form::model($account , ['method' => 'PATCH', 'action' => ['AccountController@update', $account->id]]); ?>

                <div class="col-md-12">
                                
                        <div class="">
                            <div class="form-horizontal pad15L pad15R bordered-row">

                                <div class="form-group remove-border">
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Tipo de cuenta:*</label>
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('account_type') ? ' has-error' : ''); ?>">
                                                <select class="form-control" id="account_type" name="account_type" value="<?php echo e(old('account_type')); ?>" required>
                                                    <?php $__currentLoopData = $account_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account_types): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($account->account_type == $account_types->id): ?>
                                                            <option value="<?php echo e($account_types->id); ?>" selected><?php echo e($account_types->account_name); ?></option>
                                                        <?php else: ?>
                                                            <option value="<?php echo e($account_types->id); ?>"><?php echo e($account_types->account_name); ?></option>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <?php if($errors->has('account_type')): ?>
                                                  <span class="help-block">
                                                    <strong><?php echo e($errors->first('account_type')); ?></strong>
                                                  </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                                
                                </div>
                                                
                                <div class="form-group">

                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Descrip.:*</label>
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('description') ? ' has-error' : ''); ?>">
                                                <input type="text" class="form-control" autocomplete="off" id="description" name="description"  class="form-control" value="<?php echo e($account->description); ?>" required placeholder="Descripción">
                                                <?php if($errors->has('description')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('description')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                            
                                        </div>
                                    </div>
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Saldo:</label>
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('balance') ? ' has-error' : ''); ?>">
                                                <div class="input-group">
                                                    <span class="input-group-addon">$</span>
                                                    <input type="text" class="form-control" autocomplete="off" id="balance"  pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros,solo 2 decimales" maxlength="12" class="form-control" value="<?php echo e($account->balance); ?>" readonly="readonly">
                                                    <!--<span class="input-group-addon">.00</span>-->
                                                </div>
                                                <?php if($errors->has('balance')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('balance')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                                
                                    

                                </div>
                                 

                                <div id="bankinfo" style="display:none;">           
                                    <div class="form-group">

                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Banco:*
                                                </label>
                                                <div class="col-sm-8 form-group<?php echo e($errors->has('bank_name') ? ' has-error' : ''); ?>">
                                                    <input type="text" autocomplete="off" id="bank_name" name="bank_name" maxlength="50" class="form-control"  value="<?php echo e($account->bank_name); ?>" placeholder="Banco..." required>
                                                    <?php if($errors->has('bank_name')): ?>
                                                      <span class="help-block">
                                                        <strong><?php echo e($errors->first('bank_name')); ?></strong>
                                                      </span>
                                                    <?php endif; ?>
                                                </div>
                                                
                                            </div>
                                        </div>
                                                    
                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    No. de cuenta:*
                                                </label>
                                                <div class="col-sm-8 form-group<?php echo e($errors->has('number_account') ? ' has-error' : ''); ?>">
                                                    <input type="text" autocomplete="off"  id="number_account" name="number_account" maxlength="25" class="form-control" value="<?php echo e($account->number_account); ?>" placeholder="No. de cuenta..." required>
                                                    <?php if($errors->has('number_account')): ?>
                                                      <span class="help-block">
                                                        <strong><?php echo e($errors->first('number_account')); ?></strong>
                                                      </span>
                                                    <?php endif; ?>
                                                </div>
                                                
                                            </div>
                                        </div>
                                                    
                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Cuenta CLABE:*
                                                </label>
                                                <div class="col-sm-8 form-group<?php echo e($errors->has('CLABE') ? ' has-error' : ''); ?>">
                                                    <input type="text" autocomplete="off" id="CLABE" name="CLABE"  maxlength="18" class="form-control" value="<?php echo e($account->CLABE); ?>" placeholder="Cuenta CLABE..." required>
                                                    <?php if($errors->has('CLABE')): ?>
                                                      <span class="help-block">
                                                        <strong><?php echo e($errors->first('CLABE')); ?></strong>
                                                      </span>
                                                    <?php endif; ?>
                                                </div>
                                                
                                            </div>
                                        </div>

                                    </div>
                                                
                                    <div class="form-group">

                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    No. de tarjeta:
                                                </label>
                                                <div class="col-sm-8 form-group<?php echo e($errors->has('card') ? ' has-error' : ''); ?>">
                                                    <input type="text" autocomplete="off" id="card" name="card" maxlength="19"  value="<?php echo e($account->card); ?>" class="form-control" placeholder="No. de tarjeta...">
                                                    <?php if($errors->has('card')): ?>
                                                      <span class="help-block">
                                                        <strong><?php echo e($errors->first('card')); ?></strong>
                                                      </span>
                                                    <?php endif; ?>
                                                </div>
                                                
                                            </div>
                                        </div>
                                                    
                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Sucursal:
                                                </label>
                                                <div class="col-sm-8 form-group<?php echo e($errors->has('branch_office') ? ' has-error' : ''); ?>">
                                                    <input type="text" autocomplete="off"  id="branch_office" name="branch_office"  maxlength="40" class="form-control" value="<?php echo e($account->branch_office); ?>" placeholder="Sucursal...">
                                                    <?php if($errors->has('branch_office')): ?>
                                                      <span class="help-block">
                                                        <strong><?php echo e($errors->first('branch_office')); ?></strong>
                                                      </span>
                                                    <?php endif; ?>
                                                </div>
                                                
                                            </div>
                                        </div>
                                                    
                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Correo electrónico donde se pueden enviar comprobantes de pago">?</span> Correo:
                                                </label>
                                                <div class="col-sm-8 form-group<?php echo e($errors->has('email') ? ' has-error' : ''); ?>">
                                                    <input type="email" autocomplete="off" id="email" name="email" value="<?php echo e($account->email); ?>"   maxlength="60" class="form-control" placeholder="Correo electrónico...">
                                                    <?php if($errors->has('email')): ?>
                                                      <span class="help-block">
                                                        <strong><?php echo e($errors->first('email')); ?></strong>
                                                      </span>
                                                    <?php endif; ?>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>

                            </div>

                            <div class="row" >
                                    <div class="col-md-12">
                                        <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                    </div>
                                </div>

                            <div class="button-pane mrg20T">
                                <a href="<?php echo e(url('/bank')); ?>" class="btn btn-default">Cancelar</a>
                                <button class="btn btn-success">Guardar</button>
                            </div>
                        </div>

                    
                </div>
                <?php echo Form::close(); ?>


            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<script>

    if($("#account_type").val() == 1)
    {
        $("#bankinfo").show();
        $("#bank_name").attr("required", true);
        $("#number_account").attr("required", true);
        $("#CLABE").attr("required", true);
        $("#member_colony").attr("required", true);
    }
    else
    {
        $("#bankinfo").hide();
        $("#bank_name").attr("required",false);
        $("#number_account").attr("required",false);
        $("#CLABE").attr("required",false);
        $("#member_colony").attr("required",false);
    }

    $("#account_type").on('change', function(){

        if($("#account_type").val() == 1)
        {
            $("#bankinfo").show();
            $("#bank_name").attr("required", true);
            $("#number_account").attr("required", true);
            $("#CLABE").attr("required", true);
            $("#member_colony").attr("required", true);
        }
        else
        {
            $("#bankinfo").hide();
            $("#bank_name").attr("required",false);
            $("#number_account").attr("required",false);
            $("#CLABE").attr("required",false);
            $("#member_colony").attr("required",false);
        }
        
    });

    $('#balance').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

    $('#CLABE').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>