<?php $__env->startSection('content'); ?>


<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Editar Residentes</h2>
            <p>Actualiza los datos de los residentes de la colonia</p>
        </div>
    </div>
                
    <!--Fecha-->
    <?php echo $__env->make('date', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

</div><!--BREADCRUMB END-->

<?php if($errors->has('error')): ?>
    <div class="alert alert-danger">
        <ul>    
            <li><?php echo e($errors->first('error')); ?></li>         
        </ul>
    </div>                                             
<?php endif; ?>
<?php echo $__env->make('sessionmessage', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>


<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Editar residente
            <!--<div class="header-buttons">
                <a href="#" class="btn btn-xs btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i class="glyph-icon icon-plus"></i></a>
            </div>-->
        </h3>
        
        <?php echo Form::model($user , ['method' => 'PATCH', 'action' => ['UserController@update', $user->id]]); ?>       
        <div class="example-box-wrapper">
            <div class="row">

                <div class="col-md-12">
                    
                                
                        <div class="">
                            <div class="form-horizontal pad15L pad15R bordered-row">

                                <div class="form-group remove-border">
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Residencia:
                                            </label>
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('street_id') ? ' has-error' : ''); ?>">

                                                
                                                <input type="text" class="form-control" value="<?php echo e($street_select->name_street); ?> <?php echo e($street_select->number); ?>" readonly/>
                                                <?php if($errors->has('street_id')): ?>
                                                  <span class="help-block">
                                                    <strong><?php echo e($errors->first('street_id')); ?></strong>
                                                  </span>
                                                <?php endif; ?>
                                            </div>
                                            

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Nombre de residente:*
                                            </label>
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('name_resident') ? ' has-error' : ''); ?>">
                                                <input type="text" class="form-control" id="name_resident" name="name_resident" value="<?php echo e($user->name); ?>" maxlength="50" placeholder="Nombre de residente..." >
                                                <?php if($errors->has('name_resident')): ?>
                                                  <span class="help-block">
                                                    <strong><?php echo e($errors->first('name_resident')); ?></strong>
                                                  </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                                
                                </div>
                                                
                                <div class="form-group">

                                    
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Teléfono:
                                            </label>
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('phone_resident') ? ' has-error' : ''); ?>">
                                                <input type="text" class="form-control" id="phone_resident" name="phone_resident" pattern="^[0-9]{7,20}$" title="7-20 dígitos" maxlength="20" value="<?php echo e($user->phone_resident); ?>" placeholder="Teléfono..." >
                                                <?php if($errors->has('phone_resident')): ?>
                                                  <span class="help-block">
                                                    <strong><?php echo e($errors->first('phone_resident')); ?></strong>
                                                  </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Correo electrónico:*
                                            </label>
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('email') ? ' has-error' : ''); ?>">
                                                <input type="text" class="form-control" id="email" name="email" value="<?php echo e($user->email); ?>"  maxlength="60" placeholder="Correo electrónico..." >
                                                <?php if($errors->has('email')): ?>
                                                  <span class="help-block">
                                                    <strong><?php echo e($errors->first('email')); ?></strong>
                                                  </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Permiso para reservar:*
                                            </label>
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('reservation_permission') ? ' has-error' : ''); ?>">
                                                <?php if($user->reservation_permission == "1"): ?>
                                                     <input type="checkbox" data-on-color="success" data-size="small" name="reservation_permission" class="input-switch" data-on-text="On" data-off-text="Off" checked>
                                                <?php else: ?>
                                                    <input type="checkbox" data-on-color="success" data-size="small" name="reservation_permission" class="input-switch" data-on-text="On" data-off-text="Off">
                                                <?php endif; ?>
                                                <?php if($errors->has('reservation_permission')): ?>
                                                  <span class="help-block">
                                                    <strong><?php echo e($errors->first('reservation_permission')); ?></strong>
                                                  </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>

                                    
                                </div>

                            </div>

                            <div class="row" >
                                <div class="col-md-12">
                                    <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                </div>
                            </div>

                            <div class="button-pane mrg20T">
                                <a href="<?php echo e(url('configuration/users')); ?>" class="btn btn-default">Cancelar</a>
                                <button class="btn btn-success">Guardar</button>
                            </div>
                        </div>

                    
                </div>

            </div>
        </div>
        <?php echo Form::open(); ?>


    </div>
</div>

<?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>  

<script type="text/javascript" src="../../../assets/widgets/input-switch/inputswitch.js"></script>
<script type="text/javascript">
    /* Input switch */

    $(function() { "use strict";
        $('.input-switch').bootstrapSwitch();
    });
</script>
<script>

   

    $('#phone_resident').keypress(function(tecla){

        if(tecla.charCode < 48 || tecla.charCode > 57)return false; 

    });


</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>