<?php $__env->startSection('content'); ?>

<?php echo Html::style('vendor/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css'); ?>

<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Área social</h2>
            <p>Edita las áreas sociales del residencial</p>
        </div>
    </div>
                
    <!--Fecha-->
    <?php echo $__env->make('date', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>  

</div><!--BREADCRUMB END-->

<?php if($errors->has('error')): ?>
    <div class="alert alert-danger">
        <ul>    
            <li><?php echo e($errors->first('error')); ?></li>         
        </ul>
    </div>                                             
<?php endif; ?>

<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Editar área social
        </h3>
                    
        <div class="example-box-wrapper">
            <div class="row">
                <?php echo Form::model($socialArea , ['method' => 'PATCH', 'enctype' => 'multipart/form-data', 'action' => ['SocialAreaController@update', $socialArea->id]]); ?>

                <div class="col-md-12">
                                
                        <div class="">
                            <div class="form-horizontal pad15L pad15R bordered-row">

                                <div class="form-group remove-border">

                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Nombre del área social:*
                                            </label>
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('name_social_area') ? ' has-error' : ''); ?>">
                                                <input type="text" class="form-control" id="name_social_area" name="name_social_area" maxlength="30" value="<?php echo e($socialArea->name_social_area); ?>" placeholder="Nombre del área social..." required>
                                                <?php if($errors->has('name_social_area')): ?>
                                                  <span class="help-block">
                                                    <strong><?php echo e($errors->first('name_social_area')); ?></strong>
                                                  </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- #Agrega el checkbox para limitar eventos por casa -->
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Limite mensual de área social:*
                                            </label>
                                            <div class="col-sm-8">
                                                <div class="col-sm-9 ">
                                                    <label class="checkbox-inline">
                                                        <?php if($socialArea->limit_event == "1"): ?>
                                                            <input type="checkbox" id="limit_event" name="limit_event" checked>
                                                        <?php else: ?>
                                                            <input type="checkbox" id="limit_event" name="limit_event">
                                                        <?php endif; ?>
                                                        Activar/Desactivar
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                       
                                    <div class="col-md-4 col-md-offset-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Se pueden subir archivos: jpg, jpeg ,png y pdf.Tamaño maximo del archivo 5 mb.">?</span>
                                            </label>
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('file') ? ' has-error' : ''); ?>">
                                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                                    <span class="btn btn-default btn-file">
                                                    <span class="fileinput-new"><i class="glyph-icon icon-paperclip"></i>Reglamento</span>
                                                    <span class="fileinput-exists">Cambiar</span>
                                                        <input type="file" id="file" name="file" accept="application/pdf,image/jpg,image/jpeg,image/png">
                                                    </span>
                                                    <span class="fileinput-filename"></span>
                                                    <a href="#" class="close fileinput-exists" data-dismiss="fileinput" style="float: none">×</a>
                                                </div>
                                                <?php if($errors->has('file')): ?>
                                                  <span class="help-block">
                                                    <strong><?php echo e($errors->first('file')); ?></strong>
                                                  </span>
                                                <?php endif; ?>
                                                <input type="hidden" id="imageName" name="imageName" value=""/>
                                                <input type="hidden" id="contentType" name="contentType" value=""/>
                                                <input type="hidden" id="imageData" name="imageData" value=""/>
                                                <input type="hidden" id="sizeData" name="sizeData" value=""/>
                                            </div>
                                        </div>
                                    </div>
                                                
                                </div>
                                            
                                <div class="form-group">

                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Si el área social no tiene cuota colocar 0">?</span> Cuota:*</label>
                                                <div class="col-sm-8 form-group<?php echo e($errors->has('cost') ? ' has-error' : ''); ?>">
                                                    <input type="text" class="form-control" id="cost" name="cost" maxlength="8" value="<?php echo e($socialArea->cost); ?>" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" placeholder="Cuota..." required>
                                                    <?php if($errors->has('cost')): ?>
                                                      <span class="help-block">
                                                        <strong><?php echo e($errors->first('cost')); ?></strong>
                                                      </span>
                                                    <?php endif; ?>
                                                    <div id="montoregex" style="display:none;color:#FF0000;">
                                                        <strong>solo numeros, solo 2 decimales.</strong>
                                                    </div>
                                                </div>
                                        </div>
                                    </div>
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Colocar cuantos días tiene el residente para pagar la cuota antes de que se libere la reservación">?</span> Días para pagar:</label>
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('days_reserve_stay') ? ' has-error' : ''); ?>">
                                                <input type="text" class="form-control" id="days_reserve_stay" name="days_reserve_stay" value="<?php echo e($socialArea->days_reserve_stay); ?>" pattern="^[0-9]{1,2}$" title="máximo dos digitos" maxlength="2" placeholder="Días que permanece la reservación...">
                                                <?php if($errors->has('days_reserve_stay')): ?>
                                                  <span class="help-block">
                                                    <strong><?php echo e($errors->first('days_reserve_stay')); ?></strong>
                                                  </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label for="" class="col-sm-3 control-label">Color:*</label>
                                                <div class="col-sm-9 form-group<?php echo e($errors->has('color') ? ' has-error' : ''); ?>">
                                                  
                                                        <div style="display:inline-block"/>
                                                            <button type="button" class="btn btn-default" style="background-color:<?php echo e($socialArea->color); ?>;display:inline-block;" id="cp4" >Da clic</button>
                                                        </div>
                                                        <div  style="display:inline-block"/>
                                                            <input id="cp1" type="text" style="display:inline-block;"  class="form-control" name="color" value="<?php echo e($socialArea->color); ?>" placeholder="Selecciona el color.." required/>
                                                        </div>
                                               
                                                    <?php if($errors->has('color')): ?>
                                                      <span class="help-block">
                                                        <strong><?php echo e($errors->first('color')); ?></strong>
                                                      </span>
                                                    <?php endif; ?>
                                                   
                                                    
                                                </div>
                                                 <script>
                                                        $(function() {
                                                            
                                                            $('#cp4').colorpicker({
                                                                                                
                                                                format: 'hex',

                                                            });
                                                            $('#cp4').colorpicker().on('changeColor', function(e) {
                                                                
                                                                $("#cp4").css("background-color",e.color.toString('hex'));
                                                                $("#cp1").val(e.color.toString('hex'));

                                                            });
                                                        });
                                                    </script>
                                        </div>
                                    </div>
                                                
                                </div>
                                
                                <!--#Areas Sociales para multiples casas-->
                                <div class="form-group">
                                    
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                No. de casas que pueden rentar:*
                                            </label>
                                            <!--Cambiar errores-->
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('name_social_area') ? ' has-error' : ''); ?>">
                                                <input type="input" class="form-control" id="cant_casas" name="cant_casas" value="<?php echo e($socialArea->cant_casas); ?>" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros enteros" maxlength="3" required>
                                                <!--Cambiar errores-->
                                                <?php if($errors->has('amount_charge')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('amount_charge')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Limite de aforo:
                                            </label>
                                            <!--Cambiar errores-->
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('name_social_area') ? ' has-error' : ''); ?>">
                                                <input type="input" class="form-control" id="limit_aforo" name="limit_aforo" value="<?php echo e($socialArea->limit_aforo); ?>" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros enteros" maxlength="3">
                                                <!--Cambiar errores-->
                                                <?php if($errors->has('amount_charge')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('amount_charge')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Limite de asistentes:
                                            </label>
                                            <!--Cambiar errores-->
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('name_social_area') ? ' has-error' : ''); ?>">
                                                <input type="input" class="form-control" id="limit_asist" name="limit_asist" value="<?php echo e($socialArea->limit_asist); ?>" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros enteros" maxlength="3">
                                                <!--Cambiar errores-->
                                                <?php if($errors->has('amount_charge')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('amount_charge')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                                
                                <div class="form-group">
                                                    
                                    <label class="col-sm-3 control-label">Días que se puede reservar:*</label>
                                        <div class="col-sm-9">
                                            <label class="checkbox-inline">
                                                <?php if($socialArea->monday == "1"): ?>
                                                    <input type="checkbox" id="monday" name="monday" checked>
                                                <?php else: ?>
                                                    <input type="checkbox" id="monday" name="monday">
                                                <?php endif; ?>
                                                Lunes
                                            </label>
                                            <label class="checkbox-inline">
                                                <?php if($socialArea->tuesday == "1"): ?>
                                                    <input type="checkbox" id="tuesday" name="tuesday" checked>
                                                <?php else: ?>
                                                    <input type="checkbox" id="tuesday" name="tuesday">
                                                <?php endif; ?>
                                                Martes
                                            </label>
                                            <label class="checkbox-inline"> 
                                            <!-- #Cambio wednsday por wendsday -->
                                                <?php if($socialArea->wendsday == "1"): ?>
                                                    <input type="checkbox" id="wendsday" name="wendsday" checked>
                                                <?php else: ?>
                                                    <input type="checkbox" id="wendsday" name="wendsday">
                                                <?php endif; ?>
                                                Miércoles
                                            </label>
                                            <label class="checkbox-inline">
                                                <?php if($socialArea->thursday == "1"): ?>
                                                    <input type="checkbox" id="thursday" name="thursday" checked>
                                                <?php else: ?>
                                                    <input type="checkbox" id="thursday" name="thursday">
                                                <?php endif; ?>
                                                Jueves
                                            </label>
                                            <label class="checkbox-inline">
                                                <?php if($socialArea->friday == "1"): ?>
                                                    <input type="checkbox" id="friday" name="friday" checked>
                                                <?php else: ?>
                                                    <input type="checkbox" id="friday" name="friday">
                                                <?php endif; ?>
                                                Viernes
                                            </label>
                                            <label class="checkbox-inline">
                                                <?php if($socialArea->saturday == "1"): ?>
                                                    <input type="checkbox" id="saturday" name="saturday" checked>
                                                <?php else: ?>
                                                    <input type="checkbox" id="saturday" name="saturday">
                                                <?php endif; ?>
                                                Sábado
                                            </label>
                                            <label class="checkbox-inline">
                                                <?php if($socialArea->sunday == "1"): ?>
                                                    <input type="checkbox" id="sunday" name="sunday" checked>
                                                <?php else: ?>
                                                    <input type="checkbox" id="sunday" name="sunday">
                                                <?php endif; ?>
                                                Domingo
                                            </label>
                                        </div>
                            
                                </div>

                            </div>
                        </div>

                        <div class="row" >
                                    <div class="col-md-12">
                                        <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                    </div>
                                </div>

                        <div class="button-pane mrg20T">
                            
                            <!--#Ocultar Area Social-->
                            <div class="group">
                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">
                                            Ocultar Area social:
                                        </label>
                                        <div class="col-sm-8">
                                            <div class="col-sm-9 ">
                                                <label class="checkbox-inline">
                                                    <?php if($socialArea->ocult_area == "1"): ?>
                                                        <input type="checkbox" id="ocult_area" name="ocult_area" checked>
                                                    <?php else: ?>
                                                        <input type="checkbox" id="ocult_area" name="ocult_area">
                                                    <?php endif; ?>
                                                    Ocultar/No ocultar
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--#Fin Ocultar Area Social-->
                            
                            <a href="<?php echo e(url('configuration/social_areas')); ?>" class="btn btn-default">Cancelar</a>
                            <button type="button" class="btn btn-success"  id="acept_area">Guardar</button>
                            <div style="display:none;">
                                 <button type="submit" id="acept" class="btn btn-success"></button>
                            </div>
                        </div>
                   

                </div>
                <?php echo Form::close(); ?>

            </div>

        </div>
    </div>
</div>
<?php echo Html::script('vendor/bootstrap-colorpicker/js/bootstrap-colorpicker.js'); ?>

<?php echo Html::script('vendor/compress.js/src/Compress.js'); ?>

<?php echo Html::script('vendor/compress.js/index.js'); ?>

<?php echo Html::script('js/validaciones.js'); ?>


<script>
    /*$('#days_reserve_stay').keypress(function(tecla){

        if(tecla.charCode < 48 || tecla.charCode > 57)return false; 

    });*/

    

    $("#acept_area").on('click', function(){
        /* #Cambio wednsday por wendsday */
        if($("#monday").prop('checked') || $("#tuesday").prop('checked') || $("#wendsday").prop('checked') || $("#thursday").prop('checked') || $("#friday").prop('checked') || $("#saturday").prop('checked') || $("#sunday").prop('checked') )
        {
           
            var monto = $("#cost").val();
            
            if($("#cost").val() == "")
            {
                $("#acept").click();
            }
            else
            {
                if(/^[0-9]+(\.[0-9]{1,2})?$/.test(monto))
                {
                    $("#montoregex").hide("slow");
                   
                    if($("#cost").val() == 0)
                    {
                        $("#days_reserve_stay").attr("required",false);
                        $("#acept").click();  
                                            
                    } 
                    else
                    {   
                        $("#days_reserve_stay").attr("required",true);
                        $("#acept").click();
                          
                    }
                   
                   
                    
                }
                else
                {
                    
                    event.preventDefault();
                    $("#montoregex").show("slow");
                    $("#cost").focus();
                  
                }
            }
        }
        else
        {
            alert("Tienes que seleccionar al menos un día en que se puede usar el area social");
        }
    });

    $('#cost').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

    $("#days_reserve_stay").keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

    $('#cp1').keypress(function(tecla){
    
       if(tecla.charCode < 48 || tecla.charCode > 57)return false;
       if ((tecla.charCode < 97 || tecla.charCode > 122)//letras mayusculas
                && (tecla.charCode < 65 || tecla.charCode > 90) //letras minusculas
                && (tecla.charCode != 45) //retroceso
                && (tecla.charCode != 241) //ñ
                 && (tecla.charCode != 209) //Ñ
                 && (tecla.charCode != 32) //espacio
                 && (tecla.charCode != 225) //á
                 && (tecla.charCode != 233) //é
                 && (tecla.charCode != 237) //í
                 && (tecla.charCode != 243) //ó
                 && (tecla.charCode != 250) //ú
                 && (tecla.charCode != 193) //Á
                 && (tecla.charCode != 201) //É
                 && (tecla.charCode != 205) //Í
                 && (tecla.charCode != 211) //Ó
                 && (tecla.charCode != 218) //Ú
 
              )
        return false; 

    });


comprimirImagen('file');

 function pulsar(e) { 
      tecla = (document.all) ? e.keyCode :e.which; 
      return (tecla!=13); 
    } 

</script>


<?php $__env->stopSection(); ?>



<?php echo $__env->make('master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>