<?php $__env->startSection('content'); ?>

<style>
.ui-state-hover a,
.ui-state-hover a:hover,
.ui-state-hover a:link,
.ui-state-hover a:visited,
.ui-state-focus a,
.ui-state-focus a:hover,
.ui-state-focus a:link,
.ui-state-focus a:visited {
    color: #bcbcbc;
    text-decoration: none;
}
.ui-state-active,
.ui-state-active,
.ui-state-active {
    border: 1px solid #bcbcbc;
    background: #ffffff url(images/ui-bg_glass_65_ffffff_1x400.png) 50% 50% repeat-x;
    font-weight: bold;
    color: #bcbcbc;
    cursor:pointer;
}
.ui-state-active a,
.ui-state-active a:link,
.ui-state-active a:visited {
    color: #bcbcbc;
    text-decoration: none;
}

</style>
<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Alta de residentes</h2>
            <p>Puedes ver la información de todos los residentes</p>
        </div>
    </div>
                
    <!--Fecha-->
    <?php echo $__env->make('date', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

</div><!--BREADCRUMB END-->

<?php if($errors->has('error')): ?>
    <div class="alert alert-danger">
        <ul>    
            <li><?php echo e($errors->first('error')); ?></li>         
        </ul>
    </div>                                             
<?php endif; ?>
<?php if(Session::has('message')): ?>
<div class="alert alert-success">
    <div class="bg-green alert-icon">
        <i class="glyph-icon icon-check"></i>
    </div>
    <div class="alert-content">
        <h4 class="alert-title">&nbsp;</h4>
        <p><?php echo e(Session::get('message')); ?></p>
    </div>
</div>
<?php endif; ?>

<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Alta de residentes
            <div class="header-buttons" style="padding-top:5px;">
                <?php if($errors->has('street_id') || $errors->has('name_resident') || $errors->has('phone_resident') || $errors->has('email') || $errors->has('error')): ?>
                    <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                <?php else: ?>
                    <?php if($abierto == 1): ?>
                        <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                    <?php else: ?>
                        <a href="#" id="btnabrir" class="btn btn-md btn-danger collapsed" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-plus"></i></a>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </h3>
        
        <?php echo Form::open(['method' => 'POST', 'action' => 'UserController@store', 'id' => 'formresident']); ?>        
        <div class="example-box-wrapper">
            <div class="row">

                <div class="col-md-12">
                    <?php if($errors->has('street_id') || $errors->has('name_resident') || $errors->has('phone_resident') || $errors->has('email') || $errors->has('error')): ?>
                        <div id="demo-2" class="collapse in" aria-expanded="true">
                    <?php else: ?>
                        <?php if($abierto == 1): ?>
                            <div id="demo-2" class="collapse in" aria-expanded="true">
                        <?php else: ?>
                            <div id="demo-2" class="collapse" aria-expanded="true">
                        <?php endif; ?>
                        
                    <?php endif; ?>
                                
                        <div class="">
                            <div class="form-horizontal pad15L pad15R bordered-row">

                                <div class="form-group remove-border">
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Residencia:*
                                            </label>
                                            
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('street_id') ? ' has-error' : ''); ?>">
                                                <div class="ui-widget">
                                                    <input type="text" class="form-control" id="searchstreet"  name="searchstreet" value="<?php echo e(old('searchstreet')); ?>" placeholder="Calle/piso" required>
                                                    <input type="hidden" class="form-control" id="street_id" name="street_id" value="<?php echo e(old('street_id')); ?>" placeholder="">
                                                </div>
                                                <?php if($errors->has('street_id')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('street_id')); ?></strong>
                                                    </span>
                                                <?php endif; ?> 
                                            </div>
                                               
                                        </div>

                                        </div>
                                   
                                                
                                </div>
                                                
                                <div class="form-group">

                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Nombre de residente:*
                                            </label>
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('name_resident') ? ' has-error' : ''); ?>">
                                                <input type="text" class="form-control" id="name_resident" value="<?php echo e(old('name_resident')); ?>" name="name_resident" maxlength="50" placeholder="Nombre de residente..." required>
                                                <?php if($errors->has('name_resident')): ?>
                                                  <span class="help-block">
                                                    <strong><?php echo e($errors->first('name_resident')); ?></strong>
                                                  </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Teléfono:
                                            </label>
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('phone_resident') ? ' has-error' : ''); ?>">
                                                <input type="text" class="form-control" id="phone_resident" name="phone_resident" value="<?php echo e(old('phone_resident')); ?>" pattern="^[0-9]{7,20}$" title="7-20 dígitos" maxlength="20" placeholder="Teléfono...">
                                                <?php if($errors->has('phone_resident')): ?>
                                                  <span class="help-block">
                                                    <strong><?php echo e($errors->first('phone_resident')); ?></strong>
                                                  </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Este correo electrónico se convierte en el usuario del residente">?</span> Correo electrónico:*
                                            </label>
                                            <div class="col-sm-8 form-group<?php echo e($errors->has('email') ? ' has-error' : ''); ?>">
                                                <input type="email" class="form-control" id="email" name="email" value="<?php echo e(old('email')); ?>" maxlength="60" placeholder="Correo electrónico..." required>
                                                <?php if($errors->has('email')): ?>
                                                  <span class="help-block">
                                                    <strong><?php echo e($errors->first('email')); ?></strong>
                                                  </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                

                            </div>

                            <div class="row" >
                                <div class="col-md-12">
                                    <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                </div>
                            </div>

                            <div class="button-pane mrg20T">
                                <button class="btn btn-success">Registrar residente</button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
        <?php echo Form::close(); ?>


    </div>
</div>
       

<div class="row">
    <div class="col-md-12">
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    Residentes
                </h3>
                <div class="example-box-wrapper">
                    <div class="remove-columns">

                        <div class="row" style="padding-bottom:20px;">
                            <?php echo Form::open(['method' => 'GET', 'action' => 'UserController@index', 'id' => 'formresidentes']); ?>

                            <div class="col-md-4">
                                
                                <div class="row">
                                    <label class="col-sm-5 control-label">Residencia o residente:</label>
                                    <div class="col-sm-7"> 
                                        <div class="ui-widget">
                                            <input type="text" class="form-control" id="searchstreetnumber"  value="" placeholder="Residencia o residente">
                                            <input type="hidden" class="form-control" id="streetnumber" name="streetnumber" value="" placeholder="">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-8 col-sm-11 col-xs-11" style="padding-left:20px;">
                                <div class="row mrg5R" style="float:left;">
                                    <button class="btn btn-alt btn-hover btn-primary ">
                                        <span>Filtrar</span>
                                        <i class="glyph-icon icon-arrow-right"></i>
                                    </button>    
                                    <a href="<?php echo e(action('UserController@index')); ?>" class="btn btn-alt btn-hover btn-default">
                                        <span>Eliminar filtro</span>
                                        <i class="glyph-icon icon-arrow-right"></i>
                                    </a>          
                                </div>
                            </div>
                                <?php echo Form::close(); ?>

                        </div>

                     
                        <table class="table table-condensed table-striped">
                            <thead>
                                <tr>
                                    <th>Residencia</th>
                                    <th>Nombre de residente</th>
                                    <th class="tab-center">Teléfono</th>
                                    <th class="tab-center">Correo electrónico</th>
                                    <th class="tab-center">Permiso de reservaciones</th>
                                    <th class="tab-center"></th>
                                </tr>
                            </thead>
                            <tbody>              
                                <?php $__currentLoopData = $resident; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $residents): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="truser">
                                        <td data-title="Residencia"  style="word-break:break-all"><?php echo e($residents->name_street); ?> <?php echo e($residents->number); ?></td>
                                        <td data-title="Nombre"  style="word-break:break-all"><?php echo e($residents->name); ?></td>
                                        <td data-title="Teléfono" class="tab-center"  style="word-break:break-all"><?php echo e($residents->phone_resident); ?>&nbsp;</td>
                                        <td data-title="Corre electrónico" class="tab-center"  style="word-break:break-all"><?php echo e($residents->email); ?></td>
                                        <td data-title="Permisos" class="tab-center"  style="word-break:break-all">
                                            <?php if($residents->reservation_permission == 1): ?>
                                                Activo
                                            <?php else: ?>
                                                Inactivo
                                            <?php endif; ?>
                                        </td>
                                        <td data-title="Acción" class="tab-center">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit', App\User::class)): ?>
                                                <div style="display:inline-block">
                                                        <a type="submit" href="<?php echo e(action('UserController@edit', $residents->id)); ?>"><i class="glyph-icon icon-pencil mrg5R"></i></a>
                                                    
                                                </div>
                                            <?php endif; ?>

                                            <!--<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', App\User::class)): ?>
                                                <div style="display:inline-block">
                                                    <a href="#" id="btndeleteuser<?php echo e($a++); ?>" value="<?php echo e($residents->id); ?>" data-toggle="modal" data-target="#deleteuser"><i class="glyph-icon icon-trash mrg5L"></i></a>
                                                </div>
                                            <?php endif; ?>-->
                                        </td>
                                    </tr> 
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>   
                            </tbody>
                        </table>
                    </div>

                    <div class="row">
                        <div class="col-sm-6 col-sm-offset-6">
                            <div class="dataTables_paginate paging_bootstrap" id="datatable-example_paginate">
                                <ul class="pagination">
                                   <?php echo $resident->render(); ?>

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>  
<?php echo Html::script('js/residents.js'); ?>

<script type="text/javascript" src="../../../../../assets/jquery-ui-1.12.1/jquery-ui.min.js"></script>
<script>
    $('#searchstreetnumber').autocomplete({
        minLenght:1,
        autoFocus:true,
        source: '/getstreetsresidence',
        select: function( event, ui ) {
                         
            $('#streetnumber').val(ui.item.id);
           
        }

    });

    $('#searchstreet').autocomplete({
        minLenght:1,
        autoFocus:true,
        source: '/getstreetuser',
        select: function( event, ui ) {
                         
            $('#street_id').val(ui.item.id);
           
        }

    }); 
</script>
<!--========= MODAL COMFIRMACIÓN PARA ELIMINAR =========================================================================== -->
<div id="deleteuser" class="modal fade" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-eliminar">
        <div class="modal-content">
        
            <div class="modal-header">
                <button type="button" id="" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
                <h4 class="modal-title" id="mySmallModalLabel"><span>Eliminar usuario</span></h4>
            </div>
            
            <div class="modal-body">
               
                <!-- Contenido -->
                <div class="row" id="contentindex">
                    <p style="padding-left:20px; padding-right:20px;">¿Esta seguro que desea eliminar este usuario?</p>
                    <?php if(empty($residents)): ?>

                    <?php else: ?>
                    <?php echo Form::open(['method' => 'DELETE', 'action' => ['UserController@destroy', $residents->id]]); ?>

                    <input type="hidden" id="deleteuserid" name="id" value="">                                    
                </div>
            
            </div>

            <div class="modal-footer">
                <button type="submit" id="aceptareliminar" class="btn btn-eliminar">Eliminar</button>
                <?php echo Form::close(); ?>

                <?php endif; ?>
            </div>
            
        </div>
    </div>
</div>
<!--========= TERMINA MODAL COMFIRMACIÓN PARA ELIMINAR =========================================================================== -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>